/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.graphics.EntityDebugRenderedListener;
import de.gurkenlabs.litiengine.graphics.MapDebugArgs;
import de.gurkenlabs.litiengine.graphics.TextRenderer;
import de.gurkenlabs.litiengine.input.Input;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class DebugRenderer {
    private static List<Consumer<MapDebugArgs>> mapDebugConsumer = new CopyOnWriteArrayList<Consumer<MapDebugArgs>>();
    private static List<EntityDebugRenderedListener> entityDebugListeners = new CopyOnWriteArrayList<EntityDebugRenderedListener>();

    private DebugRenderer() {
    }

    public static void addEntityDebugListener(EntityDebugRenderedListener listener) {
        entityDebugListeners.add(listener);
    }

    public static void removeEntityDebugListener(EntityDebugRenderedListener listener) {
        entityDebugListeners.remove(listener);
    }

    public static void onMapDebugRendered(Consumer<MapDebugArgs> cons) {
        mapDebugConsumer.add(cons);
    }

    public static void renderEntityDebugInfo(Graphics2D g, IEntity entity) {
        if (!Game.config().debug().isDebugEnabled()) {
            return;
        }
        if (Game.config().debug().renderEntityNames()) {
            DebugRenderer.drawMapId(g, entity);
        }
        if (Game.config().debug().renderHitBoxes() && entity instanceof ICombatEntity) {
            g.setColor(Color.RED);
            Game.graphics().renderOutline(g, ((ICombatEntity)entity).getHitBox());
        }
        if (Game.config().debug().renderBoundingBoxes()) {
            g.setColor(Color.RED);
            Game.graphics().renderOutline(g, entity.getBoundingBox());
        }
        if (Game.config().debug().renderCollisionBoxes() && entity instanceof ICollisionEntity) {
            ICollisionEntity collisionEntity = (ICollisionEntity)entity;
            g.setColor(collisionEntity.hasCollision() ? Color.RED : Color.ORANGE);
            Game.graphics().renderOutline(g, collisionEntity.getCollisionBox());
        }
        for (EntityDebugRenderedListener listener : entityDebugListeners) {
            listener.entityRendered(g, entity);
        }
    }

    public static void renderMapDebugInfo(Graphics2D g, IMap map) {
        if (Game.config().debug().renderCollisionBoxes()) {
            BasicStroke shapeStroke = new BasicStroke(1.0f / Game.world().camera().getRenderScale());
            for (Rectangle2D rectangle2D : Game.physics().getStaticCollisionBoxes()) {
                g.setColor(Color.RED);
                Game.graphics().renderOutline(g, rectangle2D, shapeStroke);
            }
        }
        if (Game.config().debug().showTilesMetric()) {
            DebugRenderer.drawTileBoundingBox(g, map, Input.mouse().getMapLocation());
        }
        MapDebugArgs args = new MapDebugArgs(map, g);
        for (Consumer consumer : mapDebugConsumer) {
            consumer.accept(args);
        }
    }

    private static void drawMapId(Graphics2D g, IEntity entity) {
        g.setColor(Color.RED);
        g.setFont(g.getFont().deriveFont(0, 4.0f));
        int x = (int)Game.world().camera().getViewportDimensionCenter(entity).getX() + 10;
        int y = (int)Game.world().camera().getViewportDimensionCenter(entity).getY();
        TextRenderer.render(g, Integer.toString(entity.getMapId()), x, y);
        String locationString = "[x:" + new DecimalFormat("##.##").format(entity.getX()) + ";y:" + new DecimalFormat("##.##").format(entity.getY()) + "]";
        TextRenderer.render(g, locationString, x, (double)y + 5.0);
    }

    private static void drawTileBoundingBox(Graphics2D g, IMap map, Point2D location) {
        Rectangle2D playerTile = MapUtilities.getTileBoundingBox(map, location);
        g.setColor(Color.CYAN);
        Game.graphics().renderOutline(g, playerTile);
        Point tileLocation = MapUtilities.getTile(map, location);
        String locationText = tileLocation.x + ", " + tileLocation.y;
        g.setFont(g.getFont().deriveFont(3.0f));
        FontMetrics fm = g.getFontMetrics();
        Point2D relative = Game.world().camera().getViewportLocation(playerTile.getX(), playerTile.getY());
        TextRenderer.render(g, locationText, (float)(relative.getX() + playerTile.getWidth() + 3.0), (float)(relative.getY() + (double)fm.getHeight()));
        List<ITile> tiles = MapUtilities.getTilesByPixelLocation(map, location);
        StringBuilder sb = new StringBuilder();
        for (ITile tile : tiles) {
            sb.append("[gid: " + tile.getGridId() + "] ");
        }
        TextRenderer.render(g, sb.toString(), (float)(relative.getX() + playerTile.getWidth() + 3.0), (float)(relative.getY() + (double)(fm.getHeight() * 2) + 2.0));
    }
}

