/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.ITileOffset;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import de.gurkenlabs.litiengine.util.MathUtilities;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public abstract class ColorLayer
implements IRenderable {
    private final IEnvironment environment;
    private final Image[][] tiles;
    private Color color;

    protected ColorLayer(IEnvironment env, Color color) {
        this.environment = env;
        this.color = color;
        this.tiles = new Image[env.getMap().getWidth()][env.getMap().getHeight()];
        this.updateSection(this.environment.getMap().getBounds());
    }

    @Override
    public void render(Graphics2D g) {
        Rectangle2D viewport = Game.world().camera().getViewport();
        IMap map = this.getEnvironment().getMap();
        for (int x = 0; x < map.getWidth(); ++x) {
            for (int y = 0; y < map.getHeight(); ++y) {
                ITileOffset tileOffset;
                Rectangle2D tileBounds = map.getTileShape(x, y).getBounds2D();
                ITile tile = map.getTileLayers().get(0).getTile(x, y);
                if (!viewport.intersects(tileBounds)) continue;
                double offsetX = -viewport.getX();
                double offsetY = -viewport.getY();
                int tileOffsetX = 0;
                int tileOffsetY = 0;
                ITileset tileset = MapUtilities.findTileSet(map, tile);
                if (tileset != null && (tileOffset = tileset.getTileOffset()) != null) {
                    tileOffsetX = tileOffset.getX();
                    tileOffsetY = tileOffset.getY();
                }
                ImageRenderer.render(g, this.tiles[x][y], offsetX + tileBounds.getX() + (double)tileOffsetX, offsetY + tileBounds.getY() + (double)tileOffsetY);
            }
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setAlpha(int ambientAlpha) {
        this.setColor(new Color(this.getColor().getRed(), this.getColor().getGreen(), this.getColor().getBlue(), MathUtilities.clamp(ambientAlpha, 0, 255)));
        this.updateSection(this.environment.getMap().getBounds());
    }

    public void setColor(Color color) {
        this.color = color;
        this.updateSection(this.environment.getMap().getBounds());
    }

    public void updateSection(Rectangle2D section) {
        if (this.getColor() == null) {
            return;
        }
        IMap map = this.getEnvironment().getMap();
        Rectangle2D tileSection = MapUtilities.getTileBoundingBox(map, section);
        if (tileSection == null) {
            return;
        }
        BufferedImage img = ImageProcessing.getCompatibleImage((int)tileSection.getWidth(), (int)tileSection.getHeight());
        Graphics2D g = img.createGraphics();
        this.renderSection(g, tileSection);
        g.dispose();
        this.setTiles(img, tileSection);
    }

    private void setTiles(BufferedImage img, Rectangle2D section) {
        IMap map = this.getEnvironment().getMap();
        Point startTile = MapUtilities.getTile(map, new Point2D.Double(section.getX(), section.getY()));
        Point endTile = MapUtilities.getTile(map, new Point2D.Double(section.getMaxX(), section.getMaxY()));
        int startX = MathUtilities.clamp(startTile.x, 0, Math.min(startTile.x + (endTile.x - startTile.x), this.tiles.length) - 1);
        int startY = MathUtilities.clamp(startTile.y, 0, Math.min(startTile.y + (endTile.y - startTile.y), this.tiles[0].length) - 1);
        int endX = MathUtilities.clamp(endTile.x, 0, Math.min(startTile.x + (endTile.x - startTile.x), this.tiles.length) - 1);
        int endY = MathUtilities.clamp(endTile.y, 0, Math.min(startTile.y + (endTile.y - startTile.y), this.tiles[0].length) - 1);
        Shape startTileShape = map.getTileShape(startX, startY);
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                Shape tile = map.getTileShape(x, y);
                Shape translatedTile = GeometricUtilities.translateShape(tile, new Point2D.Double(0.0, 0.0));
                int subX = MathUtilities.clamp((int)(tile.getBounds().getX() - startTileShape.getBounds().getX()), 0, img.getWidth() - map.getTileWidth());
                int subY = MathUtilities.clamp((int)(tile.getBounds().getY() - startTileShape.getBounds().getY()), 0, img.getHeight() - map.getTileHeight());
                BufferedImage smallImage = img.getSubimage(subX, subY, map.getTileWidth(), map.getTileHeight());
                BufferedImage clippedImage = ImageProcessing.getCompatibleImage(smallImage.getWidth(), smallImage.getHeight());
                Graphics2D g = clippedImage.createGraphics();
                g.clip(translatedTile);
                g.drawImage((Image)smallImage, 0, 0, null);
                g.dispose();
                this.tiles[x][y] = clippedImage;
            }
        }
    }

    protected abstract void renderSection(Graphics2D var1, Rectangle2D var2);

    protected IEnvironment getEnvironment() {
        return this.environment;
    }
}

