/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.graphics.ICamera;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.animation.IEntityAnimationController;
import de.gurkenlabs.litiengine.util.MathUtilities;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;

public class Camera
implements ICamera {
    private final List<DoubleConsumer> zoomChangedConsumer = new CopyOnWriteArrayList<DoubleConsumer>();
    private final List<Consumer<Point2D>> focusChangedConsumer = new CopyOnWriteArrayList<Consumer<Point2D>>();
    protected Point2D focus = new Point2D.Double();
    private long lastShake;
    private int shakeDelay;
    private int shakeDuration = 2;
    private double shakeIntensity = 1.0;
    private double shakeOffsetX;
    private double shakeOffsetY;
    private long shakeTick;
    private Rectangle2D viewPort = new Rectangle2D.Double();
    private float zoom = 1.0f;
    private float targetZoom;
    private int zoomDelay;
    private float zoomStep;
    private long zoomTick;
    private Point2D targetFocus;
    private int panTime = 0;
    private boolean clampToMap;

    @Override
    public Point2D getFocus() {
        return this.focus;
    }

    @Override
    public Point2D getMapLocation(Point2D viewPortLocation) {
        double x = viewPortLocation.getX() - this.getPixelOffsetX();
        double y = viewPortLocation.getY() - this.getPixelOffsetY();
        return new Point2D.Double(x, y);
    }

    @Override
    public double getPixelOffsetX() {
        return this.getViewPortCenterX() - (this.getFocus() != null ? this.getFocus().getX() : 0.0);
    }

    @Override
    public double getPixelOffsetY() {
        return this.getViewPortCenterY() - (this.getFocus() != null ? this.getFocus().getY() : 0.0);
    }

    @Override
    public Rectangle2D getViewport() {
        return this.viewPort;
    }

    @Override
    public Point2D getViewportDimensionCenter(IEntity entity) {
        Point2D viewPortLocation = this.getViewportLocation(entity);
        IEntityAnimationController animationController = entity.getAnimationController();
        if (animationController == null || animationController.getCurrentAnimation() == null) {
            return new Point2D.Double(viewPortLocation.getX() + (double)entity.getWidth() * 0.5, viewPortLocation.getY() + (double)entity.getHeight() * 0.5);
        }
        Spritesheet spriteSheet = animationController.getCurrentAnimation().getSpritesheet();
        if (spriteSheet == null) {
            return viewPortLocation;
        }
        return new Point2D.Double(viewPortLocation.getX() + (double)spriteSheet.getSpriteWidth() * 0.5, viewPortLocation.getY() + (double)spriteSheet.getSpriteHeight() * 0.5);
    }

    @Override
    public Point2D getViewportLocation(double x, double y) {
        return new Point2D.Double(x + this.getPixelOffsetX(), y + this.getPixelOffsetY());
    }

    @Override
    public Point2D getViewportLocation(IEntity entity) {
        return this.getViewportLocation(entity.getLocation());
    }

    @Override
    public Point2D getViewportLocation(Point2D mapLocation) {
        return this.getViewportLocation(mapLocation.getX(), mapLocation.getY());
    }

    @Override
    public float getZoom() {
        return this.zoom;
    }

    @Override
    public float getRenderScale() {
        return Game.graphics().getBaseRenderScale() * this.getZoom();
    }

    @Override
    public void onZoomChanged(DoubleConsumer zoomCons) {
        this.zoomChangedConsumer.add(zoomCons);
    }

    @Override
    public void onFocusChanged(Consumer<Point2D> focusCons) {
        this.focusChangedConsumer.add(focusCons);
    }

    @Override
    public void setFocus(Point2D focus) {
        this.focus = this.clampToMap(focus);
        double fraction = this.focus.getY() - Math.floor(this.focus.getY());
        if (MathUtilities.isInt(fraction * 4.0)) {
            this.focus.setLocation(this.focus.getX(), this.focus.getY() + 0.01);
        }
        for (Consumer<Point2D> consumer : this.focusChangedConsumer) {
            consumer.accept(this.focus);
        }
    }

    @Override
    public void setFocus(double x, double y) {
        this.setFocus(new Point2D.Double(x, y));
    }

    @Override
    public void setZoom(float targetZoom, int delay) {
        if (delay == 0) {
            for (DoubleConsumer cons : this.zoomChangedConsumer) {
                cons.accept(targetZoom);
            }
            this.zoom = targetZoom;
            this.targetZoom = 0.0f;
            this.zoomDelay = 0;
            this.zoomTick = 0L;
            this.zoomStep = 0.0f;
        } else {
            this.zoomTick = Game.loop().getTicks();
            this.targetZoom = targetZoom;
            this.zoomDelay = delay;
            double tickduration = 1000.0 / (double)Game.loop().getUpdateRate();
            double tickAmount = (double)delay / tickduration;
            float totalDelta = this.targetZoom - this.zoom;
            this.zoomStep = tickAmount > 0.0 ? (float)((double)totalDelta / tickAmount) : totalDelta;
        }
    }

    @Override
    public void shake(double intensity, int delay, int shakeDuration) {
        this.shakeTick = Game.loop().getTicks();
        this.shakeDelay = delay;
        this.shakeIntensity = intensity;
        this.shakeDuration = shakeDuration;
    }

    @Override
    public void update() {
        if (Game.world().camera() != null && !Game.world().camera().equals(this)) {
            return;
        }
        if (this.targetZoom > 0.0f) {
            if (Game.loop().getDeltaTime(this.zoomTick) >= (long)this.zoomDelay) {
                for (DoubleConsumer doubleConsumer : this.zoomChangedConsumer) {
                    doubleConsumer.accept(this.zoom);
                }
                this.zoom = this.targetZoom;
                this.targetZoom = 0.0f;
                this.zoomDelay = 0;
                this.zoomTick = 0L;
                this.zoomStep = 0.0f;
            } else {
                this.zoom += this.zoomStep;
                for (DoubleConsumer doubleConsumer : this.zoomChangedConsumer) {
                    doubleConsumer.accept(this.zoom);
                }
            }
        }
        if (this.panTime > 0) {
            if (--this.panTime <= 0) {
                this.setFocus(this.targetFocus);
                this.targetFocus = null;
                for (Consumer consumer : this.focusChangedConsumer) {
                    consumer.accept(this.focus);
                }
            } else {
                double diff = (double)this.panTime / ((double)this.panTime + 1.0);
                this.focus = new Point2D.Double(this.focus.getX() * diff + this.targetFocus.getX() * (1.0 - diff), this.focus.getY() * diff + this.targetFocus.getY() * (1.0 - diff));
            }
        }
        if (!this.isShakeEffectActive()) {
            this.shakeOffsetX = 0.0;
            this.shakeOffsetY = 0.0;
            return;
        }
        if (Game.loop().getDeltaTime(this.lastShake) > (long)this.shakeDelay) {
            this.shakeOffsetX = this.getShakeIntensity() * (double)MathUtilities.randomSign();
            this.shakeOffsetY = this.getShakeIntensity() * (double)MathUtilities.randomSign();
            this.lastShake = Game.loop().getTicks();
        }
    }

    @Override
    public void updateFocus() {
        this.setFocus(this.applyShakeEffect(this.getFocus()));
        double viewPortX = this.getFocus().getX() - this.getViewPortCenterX();
        double viewPortY = this.getFocus().getY() - this.getViewPortCenterY();
        this.viewPort = new Rectangle2D.Double(viewPortX, viewPortY, Game.window().getResolution().getWidth() / (double)this.getRenderScale(), Game.window().getResolution().getHeight() / (double)this.getRenderScale());
    }

    @Override
    public boolean isClampToMap() {
        return this.clampToMap;
    }

    @Override
    public void setClampToMap(boolean clampToMap) {
        this.clampToMap = clampToMap;
    }

    protected Point2D clampToMap(Point2D focus) {
        if (Game.world().environment() == null || Game.world().environment().getMap() == null || !this.isClampToMap()) {
            return new Point2D.Double(focus.getX(), focus.getY());
        }
        Dimension mapSize = Game.world().environment().getMap().getSizeInPixels();
        Dimension resolution = Game.window().getResolution();
        double minX = resolution.getWidth() / (double)this.getRenderScale() / 2.0;
        double maxX = mapSize.getWidth() - minX;
        double minY = resolution.getHeight() / (double)this.getRenderScale() / 2.0;
        double maxY = mapSize.getHeight() - minY;
        double x = mapSize.getWidth() * (double)this.getRenderScale() < resolution.getWidth() ? minX : MathUtilities.clamp(focus.getX(), minX, maxX);
        double y = mapSize.getHeight() * (double)this.getRenderScale() < resolution.getHeight() ? minY : MathUtilities.clamp(focus.getY(), minY, maxY);
        return new Point2D.Double(x, y);
    }

    private Point2D applyShakeEffect(Point2D cameraLocation) {
        if (this.isShakeEffectActive()) {
            return new Point2D.Double(cameraLocation.getX() + this.shakeOffsetX, cameraLocation.getY() + this.shakeOffsetY);
        }
        return cameraLocation;
    }

    private int getShakeDuration() {
        return this.shakeDuration;
    }

    private double getShakeIntensity() {
        return this.shakeIntensity;
    }

    private long getShakeTick() {
        return this.shakeTick;
    }

    private double getViewPortCenterX() {
        return Game.window().getResolution().getWidth() * 0.5 / (double)this.getRenderScale();
    }

    private double getViewPortCenterY() {
        return Game.window().getResolution().getHeight() * 0.5 / (double)this.getRenderScale();
    }

    private boolean isShakeEffectActive() {
        return this.getShakeTick() != 0L && Game.loop().getDeltaTime(this.getShakeTick()) < (long)this.getShakeDuration();
    }

    @Override
    public void pan(Point2D focus, int duration) {
        this.targetFocus = this.clampToMap(focus);
        this.panTime = duration;
    }

    @Override
    public void pan(double x, double y, int duration) {
        this.pan(new Point2D.Double(x, y), duration);
    }
}

