/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.ITerrain;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimation;
import de.gurkenlabs.litiengine.environment.tilemap.ITilesetEntry;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Animation;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class TilesetEntry
extends CustomPropertyProvider
implements ITilesetEntry {
    private static final long serialVersionUID = -3356859779159630943L;
    private transient ITerrain[] terrains;
    @XmlAttribute
    private Integer id;
    @XmlAttribute
    private String terrain;
    @XmlElement(required=false)
    private Animation animation;

    @Override
    public int getId() {
        if (this.id == null) {
            return 0;
        }
        return this.id;
    }

    @Override
    public ITerrain[] getTerrain() {
        return this.terrains;
    }

    @Override
    public ITileAnimation getAnimation() {
        return this.animation;
    }

    protected void setTerrains(ITerrain[] terrains) {
        this.terrains = terrains;
    }

    protected int[] getTerrainIds() {
        int[] terrainIds = new int[]{-1, -1, -1, -1};
        if (this.terrain == null || this.terrain.isEmpty()) {
            return terrainIds;
        }
        int[] ids = ArrayUtilities.getIntegerArray(this.terrain);
        if (ids.length != 4) {
            return terrainIds;
        }
        terrainIds = ids;
        return terrainIds;
    }

    public String toString() {
        return Arrays.toString(this.getTerrainIds());
    }
}

