/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.ICustomProperty;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.ITilesetEntry;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import java.awt.Point;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Tile
extends CustomPropertyProvider
implements ITile,
Serializable {
    public static final int NONE = 0;
    public static final Tile EMPTY = new Tile(0);
    protected static final int FLIPPED_HORIZONTALLY_FLAG = Integer.MIN_VALUE;
    protected static final int FLIPPED_VERTICALLY_FLAG = 0x40000000;
    protected static final int FLIPPED_DIAGONALLY_FLAG = 0x20000000;
    private static final long serialVersionUID = -7597673646108642906L;
    @XmlAttribute
    private Integer gid;
    private transient Point tileCoordinate;
    private transient ITilesetEntry tilesetEntry;
    private transient boolean flippedDiagonally;
    private transient boolean flippedHorizontally;
    private transient boolean flippedVertically;
    private transient boolean flipped;

    public Tile() {
    }

    public Tile(int gidBitmask) {
        this.flippedDiagonally = (gidBitmask & 0x20000000) != 0;
        this.flippedHorizontally = (gidBitmask & Integer.MIN_VALUE) != 0;
        this.flippedVertically = (gidBitmask & 0x40000000) != 0;
        this.flipped = this.isFlippedDiagonally() || this.isFlippedHorizontally() || this.isFlippedVertically();
        this.gid = gidBitmask & 0x1FFFFFFF;
    }

    @Override
    public boolean hasCustomProperty(String name) {
        return this.getTilesetEntry() == null ? super.hasCustomProperty(name) : this.getTilesetEntry().hasCustomProperty(name);
    }

    @Override
    public Map<String, ICustomProperty> getProperties() {
        return this.getTilesetEntry() == null ? super.getProperties() : this.getTilesetEntry().getProperties();
    }

    @Override
    public void setProperties(Map<String, ICustomProperty> props) {
        if (this.getTilesetEntry() == null) {
            super.setProperties(props);
        } else {
            this.getTilesetEntry().setProperties(props);
        }
    }

    @Override
    public boolean isFlippedDiagonally() {
        return this.flippedDiagonally;
    }

    @Override
    public boolean isFlippedHorizontally() {
        return this.flippedHorizontally;
    }

    @Override
    public boolean isFlippedVertically() {
        return this.flippedVertically;
    }

    @Override
    public boolean isFlipped() {
        return this.flipped;
    }

    @Override
    public int getGridId() {
        if (this.gid == null) {
            return 0;
        }
        return this.gid;
    }

    @Override
    public Point getTileCoordinate() {
        return this.tileCoordinate;
    }

    public void setTileCoordinate(Point tileCoordinate) {
        this.tileCoordinate = tileCoordinate;
    }

    @Override
    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (!(anObject instanceof ITile) || anObject == null) {
            return false;
        }
        ITile other = (ITile)anObject;
        return this.getGridId() == other.getGridId() && this.isFlippedDiagonally() == other.isFlippedDiagonally() && this.isFlippedHorizontally() == other.isFlippedHorizontally() && this.isFlippedVertically() == other.isFlippedVertically();
    }

    @Override
    public int hashCode() {
        int hash = this.getGridId();
        if (this.isFlipped()) {
            if (this.isFlippedDiagonally()) {
                hash |= 0x20000000;
            }
            if (this.isFlippedHorizontally()) {
                hash |= Integer.MIN_VALUE;
            }
            if (this.isFlippedVertically()) {
                hash |= 0x40000000;
            }
        }
        return hash ^ Objects.hashCode(this.getTilesetEntry());
    }

    public String toString() {
        return this.getGridId() + String.valueOf(this.getTilesetEntry());
    }

    protected void setTilesetEntry(ITilesetEntry entry) {
        this.tilesetEntry = entry;
    }

    @Override
    public ITilesetEntry getTilesetEntry() {
        return this.tilesetEntry;
    }

    private void beforeMarshal(Marshaller m) {
        if (this.gid != null && this.gid == 0) {
            this.gid = null;
        }
    }
}

