/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import de.gurkenlabs.litiengine.environment.tilemap.xml.DecimalFloatAdapter;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Map;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Polyline;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class MapObject
extends CustomPropertyProvider
implements IMapObject {
    private static final long serialVersionUID = -6001981756772928868L;
    @XmlAttribute
    private int id;
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String type;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=DecimalFloatAdapter.class)
    private Float x;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=DecimalFloatAdapter.class)
    private Float y;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=DecimalFloatAdapter.class)
    private Float width;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=DecimalFloatAdapter.class)
    private Float height;
    @XmlAttribute
    private Integer gid;
    @XmlElement(name="polyline")
    private Polyline polyline;
    private transient MapObjectLayer layer;

    public MapObject() {
        this.setX(0.0f);
        this.setY(0.0f);
        this.setWidth(0.0f);
        this.setHeight(0.0f);
    }

    public MapObject(MapObject mapObjectToBeCopied) {
        super(mapObjectToBeCopied);
        this.setName(mapObjectToBeCopied.getName());
        this.setId(Game.world().environment().getNextMapId());
        this.polyline = mapObjectToBeCopied.getPolyline() != null && !mapObjectToBeCopied.getPolyline().getPoints().isEmpty() ? new Polyline(mapObjectToBeCopied.getPolyline()) : null;
        this.setType(mapObjectToBeCopied.getType());
        this.setX(mapObjectToBeCopied.getX());
        this.setY(mapObjectToBeCopied.getY());
        this.setWidth(mapObjectToBeCopied.getWidth());
        this.setHeight(mapObjectToBeCopied.getHeight());
    }

    public MapObject(MapObject mapObjectToBeCopied, boolean keepID) {
        this(mapObjectToBeCopied);
        if (keepID) {
            this.setId(mapObjectToBeCopied.getId());
        }
    }

    public static Rectangle2D getBounds2D(IMapObject ... objects) {
        return MapObject.getBounds(objects);
    }

    public static Rectangle2D getBounds2D(Iterable<IMapObject> objects) {
        return MapObject.getBounds(objects);
    }

    public static Rectangle2D getBounds(IMapObject ... objects) {
        return MapObject.getBounds(Arrays.asList(objects));
    }

    public static Rectangle2D getBounds(Iterable<IMapObject> objects) {
        float minX = -1.0f;
        float minY = -1.0f;
        float maxX = -1.0f;
        float maxY = -1.0f;
        for (IMapObject item : objects) {
            if (minX == -1.0f || item.getX() < minX) {
                minX = item.getX();
            }
            if (minY == -1.0f || item.getY() < minY) {
                minY = item.getY();
            }
            if (maxX == -1.0f || item.getBoundingBox().getMaxX() > (double)maxX) {
                maxX = (int)item.getBoundingBox().getMaxX();
            }
            if (maxY != -1.0f && !(item.getBoundingBox().getMaxY() > (double)maxY)) continue;
            maxY = (int)item.getBoundingBox().getMaxY();
        }
        return new Rectangle2D.Float(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public int compareTo(IMapObject obj) {
        if (obj == null) {
            return 1;
        }
        if (this.getName() == null) {
            if (obj.getName() == null) {
                return 0;
            }
            return -1;
        }
        return this.getName().compareTo(obj.getName());
    }

    @Override
    public int getGridId() {
        if (this.gid == null) {
            return 0;
        }
        return this.gid;
    }

    @Override
    public Rectangle2D getBoundingBox() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.width.floatValue(), this.height.floatValue());
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Point2D getLocation() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Polyline getPolyline() {
        return this.polyline;
    }

    @Override
    @XmlTransient
    public void setGridId(int gid) {
        this.gid = gid;
    }

    @Override
    @XmlTransient
    public void setHeight(float height) {
        this.height = Float.valueOf(height);
    }

    @Override
    @XmlTransient
    public void setId(int id) {
        this.id = id;
    }

    @Override
    @XmlTransient
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @XmlTransient
    public void setType(String type) {
        this.type = type;
    }

    @Override
    @XmlTransient
    public void setWidth(float width) {
        this.width = Float.valueOf(width);
    }

    @Override
    @XmlTransient
    public void setX(float x) {
        if (this.isInfiniteMap()) {
            Map map = (Map)this.getLayer().getMap();
            this.x = Float.valueOf(x + (float)(map.getChunkOffsetX() * map.getTileWidth()));
            return;
        }
        this.x = Float.valueOf(x);
    }

    @Override
    @XmlTransient
    public void setY(float y) {
        if (this.isInfiniteMap()) {
            Map map = (Map)this.getLayer().getMap();
            this.y = Float.valueOf(y + (float)(map.getChunkOffsetY() * map.getTileHeight()));
            return;
        }
        this.y = Float.valueOf(y);
    }

    @Override
    public float getX() {
        if (this.isInfiniteMap()) {
            Map map = (Map)this.getLayer().getMap();
            return this.x.floatValue() - (float)(map.getChunkOffsetX() * map.getTileWidth());
        }
        return this.x.floatValue();
    }

    @Override
    public float getY() {
        if (this.isInfiniteMap()) {
            Map map = (Map)this.getLayer().getMap();
            return this.y.floatValue() - (float)(map.getChunkOffsetY() * map.getTileHeight());
        }
        return this.y.floatValue();
    }

    @XmlTransient
    public void setPolyline(Polyline polyline) {
        this.polyline = polyline;
    }

    @Override
    public float getWidth() {
        return this.width.floatValue();
    }

    @Override
    public float getHeight() {
        return this.height.floatValue();
    }

    void afterUnmarshal(Unmarshaller u, Object parent) {
        if (this.gid != null && this.gid == 0) {
            this.gid = null;
        }
    }

    @Override
    public IMapObjectLayer getLayer() {
        return this.layer;
    }

    protected void setLayer(MapObjectLayer layer) {
        this.layer = layer;
    }

    private boolean isInfiniteMap() {
        return this.getLayer() != null && this.getLayer().getMap() != null && this.getLayer().getMap().isInfinite() && this.getLayer().getMap() instanceof Map;
    }
}

