/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.IMapImage;
import de.gurkenlabs.litiengine.environment.tilemap.xml.ColorAdapter;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class MapImage
extends CustomPropertyProvider
implements IMapImage {
    private static final long serialVersionUID = -3571362172734426098L;
    @XmlAttribute
    private String source;
    @XmlAttribute(name="trans")
    @XmlJavaTypeAdapter(value=ColorAdapter.class)
    private Color transparentcolor;
    @XmlAttribute
    private int width;
    @XmlAttribute
    private int height;
    @XmlTransient
    private String absolutePath;

    @Override
    public String getAbsoluteSourcePath() {
        return this.absolutePath;
    }

    @Override
    public Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public File getSourceFile() {
        return new File(this.getSource());
    }

    @Override
    public Color getTransparentColor() {
        return this.transparentcolor;
    }

    public int getWidth() {
        return this.width;
    }

    public void setAbsolutePath(String mapPath) {
        this.absolutePath = FileUtilities.combine(mapPath, this.getSource());
    }

    @Override
    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (!(anObject instanceof IMapImage) || anObject == null) {
            return false;
        }
        IMapImage other = (IMapImage)anObject;
        return this.getTransparentColor().equals(other.getTransparentColor()) && this.getAbsoluteSourcePath().equals(other.getAbsoluteSourcePath());
    }

    @Override
    public int hashCode() {
        return this.getAbsoluteSourcePath().hashCode() ^ this.getTransparentColor().hashCode();
    }

    public String toString() {
        return this.getAbsoluteSourcePath();
    }
}

