/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.ICustomProperty;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class CustomPropertyAdapter
extends XmlAdapter<PropertyList, Map<String, ICustomProperty>> {
    @Override
    public Map<String, ICustomProperty> unmarshal(PropertyList v) {
        Hashtable<String, ICustomProperty> map = new Hashtable<String, ICustomProperty>(v.properties.size());
        for (Property property : v.properties) {
            map.put(property.name, new CustomProperty(property.type, property.value != null ? property.value : property.contents));
        }
        return map;
    }

    @Override
    public PropertyList marshal(Map<String, ICustomProperty> v) {
        if (v.isEmpty()) {
            return null;
        }
        ArrayList<Property> list = new ArrayList<Property>(v.size());
        for (Map.Entry<String, ICustomProperty> entry : v.entrySet()) {
            ICustomProperty property = entry.getValue();
            String value = property.getAsString();
            Property saved = new Property(entry.getKey(), property.getType());
            if (value.contains("\n")) {
                saved.contents = value;
            } else {
                saved.value = value;
            }
            list.add(saved);
        }
        return new PropertyList(list);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class PropertyList {
        @XmlElement(name="property")
        List<Property> properties;

        PropertyList() {
        }

        PropertyList(List<Property> properties) {
            this.properties = properties;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class Property {
        @XmlAttribute
        String name;
        @XmlAttribute
        String type;
        @XmlAttribute
        String value;
        @XmlValue
        String contents;

        Property() {
        }

        Property(String name, String type) {
            this.name = name;
            this.type = type == null ? "string" : type;
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.type == null) {
                this.type = "string";
            }
        }

        private void beforeMarshal(Marshaller m) {
            if (this.type.equals("string")) {
                this.type = null;
            }
        }
    }
}

