/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObject;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="blueprint")
public class Blueprint
extends MapObject {
    private static final long serialVersionUID = -7235380251249427834L;
    @XmlElementWrapper(name="items")
    @XmlElement(name="object")
    private List<MapObject> items = new ArrayList<MapObject>();
    @XmlTransient
    private boolean keepIds;

    public Blueprint() {
    }

    public Blueprint(String name, MapObject ... items) {
        this(name, false, items);
    }

    public Blueprint(String name, boolean keepIds, MapObject ... items) {
        this.keepIds = keepIds;
        this.setType(MapObjectType.AREA.toString());
        this.setName(name);
        Rectangle2D bounds = MapObject.getBounds(items);
        this.setWidth((float)bounds.getWidth());
        this.setHeight((float)bounds.getHeight());
        for (MapObject item : items) {
            MapObject newItem = new MapObject(item, this.keepIds());
            newItem.setX((float)((double)item.getX() - bounds.getX()));
            newItem.setY((float)((double)item.getY() - bounds.getY()));
            this.items.add(newItem);
        }
    }

    @XmlTransient
    public Iterable<MapObject> getItems() {
        return this.items;
    }

    public boolean keepIds() {
        return this.keepIds;
    }

    public List<IMapObject> build(Point2D location) {
        return this.build(Math.round((float)location.getX()), Math.round((float)location.getY()));
    }

    public List<IMapObject> build(float x, float y) {
        ArrayList<IMapObject> builtObjects = new ArrayList<IMapObject>();
        for (MapObject item : this.getItems()) {
            MapObject newObject = new MapObject(item, this.keepIds());
            newObject.setX(newObject.getX() + x);
            newObject.setY(newObject.getY() + y);
            builtObjects.add(newObject);
        }
        return builtObjects;
    }
}

