/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimation;
import de.gurkenlabs.litiengine.environment.tilemap.ITileLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.environment.tilemap.MapOrientation;
import de.gurkenlabs.litiengine.environment.tilemap.StaggerAxis;
import de.gurkenlabs.litiengine.environment.tilemap.StaggerIndex;
import de.gurkenlabs.litiengine.util.MathUtilities;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MapUtilities {
    private static final Map<String, ITileAnimation> animations = new ConcurrentHashMap<String, ITileAnimation>();
    private static final Map<String, Boolean> hasAnimation = new ConcurrentHashMap<String, Boolean>();

    private MapUtilities() {
        throw new UnsupportedOperationException();
    }

    public static int getMaxMapId(IMap map) {
        int maxId = 0;
        if (map == null || map.getMapObjectLayers() == null) {
            return maxId;
        }
        for (IMapObjectLayer objectLayer : map.getMapObjectLayers()) {
            if (objectLayer == null || objectLayer.getMapObjects() == null) continue;
            for (IMapObject mapObject : objectLayer.getMapObjects()) {
                if (mapObject == null || mapObject.getId() <= maxId) continue;
                maxId = mapObject.getId();
            }
        }
        return maxId;
    }

    public static Point2D getCenterMapLocation() {
        if (Game.world().environment() == null || Game.world().environment().getMap() == null) {
            return new Point2D.Double();
        }
        return MapUtilities.getCenterMapLocation(Game.world().environment().getMap());
    }

    public static Point2D getCenterMapLocation(IMap map) {
        return new Point2D.Double((double)map.getSizeInPixels().width / 2.0, (double)map.getSizeInPixels().height / 2.0);
    }

    public static Rectangle2D getTileBoundingBox(Point2D mapLocation) {
        if (Game.world().environment() == null || Game.world().environment().getMap() == null) {
            return new Rectangle2D.Double();
        }
        return MapUtilities.getTileBoundingBox(Game.world().environment().getMap(), mapLocation);
    }

    public static Rectangle2D getTileBoundingBox(IMap map, Point2D mapLocation) {
        Point location = MapUtilities.getTile(map, mapLocation);
        return new Rectangle2D.Double((double)location.x * map.getTileSize().getWidth(), (double)location.y * map.getTileSize().getHeight(), map.getTileSize().getWidth(), map.getTileSize().getHeight());
    }

    public static Rectangle2D getTileBoundingBox(int x, int y) {
        return MapUtilities.getTileBoundingBox(new Point(x, y));
    }

    public static Rectangle2D getTileBoundingBox(Point tile) {
        if (Game.world().environment() == null || Game.world().environment().getMap() == null) {
            return new Rectangle2D.Double();
        }
        return MapUtilities.getTileBoundingBox(Game.world().environment().getMap(), tile);
    }

    public static Rectangle2D getTileBoundingBox(IMap map, Point tile) {
        if (map == null || tile == null) {
            return null;
        }
        return map.getTileShape(tile.x, tile.y).getBounds2D();
    }

    public static Rectangle2D getTileBoundingBox(IMap map, Rectangle2D box) {
        int minX = (int)MathUtilities.clamp(box.getX(), 0.0, (double)(map.getSizeInPixels().width - 1));
        int minY = (int)MathUtilities.clamp(box.getY(), 0.0, (double)(map.getSizeInPixels().height - 1));
        int maxX = (int)MathUtilities.clamp(box.getMaxX(), 0.0, (double)(map.getSizeInPixels().width - 1));
        int maxY = (int)MathUtilities.clamp(box.getMaxY(), 0.0, (double)(map.getSizeInPixels().height - 1));
        Point minTilePoint = MapUtilities.getTile(map, minX, minY);
        Point maxTilePoint = MapUtilities.getTile(map, maxX, maxY);
        Rectangle2D minTileBounds = map.getTileShape(MathUtilities.clamp(minTilePoint.x, 0, map.getWidth() - 1), MathUtilities.clamp(minTilePoint.y, 0, map.getHeight() - 1)).getBounds2D();
        Rectangle2D maxTileBounds = map.getTileShape(MathUtilities.clamp(maxTilePoint.x, 0, map.getWidth() - 1), MathUtilities.clamp(maxTilePoint.y, 0, map.getHeight() - 1)).getBounds2D();
        return new Rectangle2D.Double(minTileBounds.getX(), minTileBounds.getY(), maxTileBounds.getMaxX() - minTileBounds.getX(), maxTileBounds.getMaxY() - minTileBounds.getY());
    }

    public static Point getTile(Point2D mapLocation) {
        if (Game.world().environment() == null) {
            return new Point(-1, -1);
        }
        return MapUtilities.getTile(Game.world().environment().getMap(), mapLocation);
    }

    public static Point getTile(IMap map, Point2D mapLocation) {
        return MapUtilities.getTile(map, mapLocation.getX(), mapLocation.getY());
    }

    public static Point getTile(IMap map, double x, double y) {
        int yCoord;
        int jumpWidth = map.getTileWidth();
        int jumpHeight = map.getTileHeight();
        int xCoord = x < 0.0 && -x < (double)jumpWidth ? -1 : (int)(x / (double)jumpWidth);
        int n = yCoord = y < 0.0 && -y < (double)jumpHeight ? -1 : (int)(y / (double)jumpHeight);
        if (map.getOrientation() != MapOrientation.HEXAGONAL) {
            return new Point(xCoord, yCoord);
        }
        StaggerAxis staggerAxis = map.getStaggerAxis();
        StaggerIndex staggerIndex = map.getStaggerIndex();
        int s = map.getHexSideLength();
        int t = staggerAxis == StaggerAxis.X ? (map.getTileWidth() - s) / 2 : (map.getTileHeight() - s) / 2;
        int r = staggerAxis == StaggerAxis.X ? map.getTileHeight() / 2 : map.getTileWidth() / 2;
        jumpWidth = staggerAxis == StaggerAxis.X ? t + s : map.getTileWidth();
        jumpHeight = staggerAxis == StaggerAxis.X ? map.getTileHeight() : t + s;
        xCoord = x < 0.0 ? (int)(x / (double)jumpWidth) - 1 : (int)(x / (double)jumpWidth);
        int n2 = yCoord = y < 0.0 ? (int)(y / (double)jumpHeight) - 1 : (int)(y / (double)jumpHeight);
        if (staggerAxis == StaggerAxis.X && MapUtilities.isStaggeredRowOrColumn(staggerIndex, xCoord)) {
            yCoord = (int)((y - (double)(jumpHeight / 2)) / (double)jumpHeight);
            yCoord = y < (double)(jumpHeight / 2) ? yCoord - 1 : yCoord;
        } else if (staggerAxis == StaggerAxis.Y && MapUtilities.isStaggeredRowOrColumn(staggerIndex, yCoord)) {
            xCoord = (int)((x - (double)(jumpWidth / 2)) / (double)jumpWidth);
            xCoord = x < (double)(jumpWidth / 2) ? xCoord - 1 : xCoord;
        }
        return MapUtilities.assessHexStaggering(staggerAxis, staggerIndex, new Point(xCoord, yCoord), s, t, r, jumpWidth, jumpHeight, x, y);
    }

    public static boolean isStaggeredRowOrColumn(StaggerIndex staggerIndex, int index) {
        return staggerIndex == StaggerIndex.ODD && MathUtilities.isOddNumber(index) || staggerIndex == StaggerIndex.EVEN && !MathUtilities.isOddNumber(index);
    }

    private static Point assessHexStaggering(StaggerAxis staggerAxis, StaggerIndex staggerIndex, Point tileLocation, int s, int t, int r, int jumpWidth, int jumpHeight, double mouseX, double mouseY) {
        int y;
        int xIndex = tileLocation.x;
        int yIndex = tileLocation.y;
        int x = MapUtilities.isStaggeredRowOrColumn(staggerIndex, yIndex) && staggerAxis == StaggerAxis.Y ? xIndex * jumpWidth + r : xIndex * jumpWidth;
        Polygon hex = GeometricUtilities.getHex(x, y = MapUtilities.isStaggeredRowOrColumn(staggerIndex, xIndex) && staggerAxis == StaggerAxis.X ? yIndex * jumpHeight + r : yIndex * jumpHeight, staggerAxis, s, r, t);
        if (hex.contains(mouseX, mouseY)) {
            return new Point(xIndex, yIndex);
        }
        if (mouseY < hex.getBounds2D().getY() + hex.getBounds2D().getHeight() / 2.0) {
            if (staggerAxis == StaggerAxis.X) {
                yIndex = MapUtilities.isStaggeredRowOrColumn(staggerIndex, xIndex) ? yIndex : yIndex - 1;
                --xIndex;
            }
            if (staggerAxis == StaggerAxis.Y) {
                xIndex = MapUtilities.isStaggeredRowOrColumn(staggerIndex, yIndex) ? xIndex : xIndex - 1;
                --yIndex;
            }
        } else if (mouseY >= hex.getBounds2D().getY() + hex.getBounds2D().getHeight() / 2.0) {
            if (staggerAxis == StaggerAxis.X) {
                yIndex = MapUtilities.isStaggeredRowOrColumn(staggerIndex, xIndex) ? yIndex + 1 : yIndex;
                --xIndex;
            }
            if (staggerAxis == StaggerAxis.Y) {
                xIndex = MapUtilities.isStaggeredRowOrColumn(staggerIndex, yIndex) ? xIndex + 1 : xIndex;
                --yIndex;
            }
        }
        return new Point(xIndex, yIndex);
    }

    public static Point2D getMapLocation(IMap map, Point tileLocation) {
        return new Point2D.Double((double)tileLocation.x * map.getTileSize().getWidth(), (double)tileLocation.y * map.getTileSize().getHeight());
    }

    public static List<ITile> getTilesByPixelLocation(IMap map, Point2D location) {
        ArrayList<ITile> tilesAtLocation = new ArrayList<ITile>();
        if (map.getTileLayers() == null || map.getTileLayers().isEmpty()) {
            return tilesAtLocation;
        }
        Point tileLocation = MapUtilities.getTile(map, location);
        for (ITileLayer layer : map.getTileLayers()) {
            ITile tile = layer.getTile(tileLocation.x, tileLocation.y);
            if (tile == null) continue;
            tilesAtLocation.add(tile);
        }
        return tilesAtLocation;
    }

    public static ITile getTopMostTile(Point2D location) {
        if (Game.world().environment() == null || Game.world().environment().getMap() == null) {
            return null;
        }
        return MapUtilities.getTopMostTile(Game.world().environment().getMap(), location);
    }

    public static ITile getTopMostTile(IMap map, Point2D location) {
        if (map.getTileLayers() == null || map.getTileLayers().isEmpty()) {
            return null;
        }
        return MapUtilities.getTopMostTile(MapUtilities.getTile(map, location));
    }

    public static ITile getTopMostTile(Point point) {
        if (Game.world().environment() == null || Game.world().environment().getMap() == null) {
            return null;
        }
        return MapUtilities.getTopMostTile(Game.world().environment().getMap(), point);
    }

    public static ITile getTopMostTile(IMap map, Point point) {
        Point tileLocation = point;
        ITile tile = null;
        for (ITileLayer layer : map.getTileLayers()) {
            ITile tileOfLayer = layer.getTile(tileLocation.x, tileLocation.y);
            if (tileOfLayer == null || tileOfLayer.getGridId() == 0) continue;
            tile = tileOfLayer;
        }
        return tile;
    }

    public static boolean hasAnimation(IMap map, ITile tile) {
        ITileset tileset = MapUtilities.findTileSet(map, tile);
        if (tileset == null || tileset.getFirstGridId() > tile.getGridId()) {
            return false;
        }
        int index = tile.getGridId() - tileset.getFirstGridId();
        ITileAnimation animation = MapUtilities.getAnimation(map, index);
        return animation != null && !animation.getFrames().isEmpty();
    }

    public static ITileAnimation getAnimation(IMap map, int gId) {
        String cacheKey = map.getName() + "[" + gId + "]";
        if (hasAnimation.containsKey(cacheKey) && !hasAnimation.get(cacheKey).booleanValue()) {
            return null;
        }
        if (animations.containsKey(cacheKey)) {
            return animations.get(cacheKey);
        }
        for (ITileset tileset : map.getTilesets()) {
            if (!tileset.containsTile(gId)) continue;
            ITileAnimation anim = tileset.getAnimation(gId);
            boolean animation = false;
            if (anim != null) {
                animations.put(cacheKey, anim);
                animation = true;
            }
            hasAnimation.put(cacheKey, animation);
            return anim;
        }
        return null;
    }

    public static ITileset findTileSet(IMap map, ITile tile) {
        if (map == null || tile == null) {
            return null;
        }
        ITileset match = null;
        for (ITileset tileset : map.getTilesets()) {
            if (!tileset.containsTile(tile)) continue;
            match = tileset;
            break;
        }
        return match;
    }

    public static Path2D convertPolylineToPath(IMapObject mapObject) {
        if (mapObject == null || mapObject.getPolyline() == null || mapObject.getPolyline().getPoints().isEmpty()) {
            return null;
        }
        Path2D.Float path = new Path2D.Float();
        ((Path2D)path).moveTo(mapObject.getLocation().getX(), mapObject.getLocation().getY());
        for (int i = 1; i < mapObject.getPolyline().getPoints().size(); ++i) {
            Point2D point = mapObject.getPolyline().getPoints().get(i);
            ((Path2D)path).lineTo(mapObject.getLocation().getX() + point.getX(), mapObject.getLocation().getY() + point.getY());
        }
        return path;
    }

    public static List<Point2D> convertPolylineToPointList(IMapObject mapObject) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        if (mapObject == null || mapObject.getPolyline() == null || mapObject.getPolyline().getPoints().isEmpty()) {
            return points;
        }
        for (int i = 1; i < mapObject.getPolyline().getPoints().size(); ++i) {
            Point2D point = mapObject.getPolyline().getPoints().get(i);
            points.add(new Point2D.Double(mapObject.getLocation().getX() + point.getX(), mapObject.getLocation().getY() + point.getY()));
        }
        return points;
    }

    public static IMapObject findMapObject(IMap map, int id) {
        for (IMapObjectLayer layer : map.getMapObjectLayers()) {
            for (IMapObject obj : layer.getMapObjects()) {
                if (obj.getId() != id) continue;
                return obj;
            }
        }
        return null;
    }
}

