/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.tilemap.IImageLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ILayer;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapRenderer;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimation;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimationFrame;
import de.gurkenlabs.litiengine.environment.tilemap.ITileLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Optional;

public abstract class MapRenderer
implements IMapRenderer {
    @Override
    public void render(Graphics2D g, IMap map, Rectangle2D viewport, RenderType ... renderTypes) {
        for (ILayer layer : map.getRenderLayers()) {
            if (layer == null || !MapRenderer.shouldBeRendered(layer, renderTypes)) continue;
            if (layer instanceof ITileLayer) {
                this.renderTileLayerImage(g, (ITileLayer)layer, map, viewport);
            }
            if (!(layer instanceof IImageLayer)) continue;
            MapRenderer.renderImageLayer(g, (IImageLayer)layer, viewport);
        }
    }

    @Override
    public BufferedImage getImage(IMap map, RenderType ... renderTypes) {
        String cacheKey = MapRenderer.getCacheKey(map) + "_" + renderTypes;
        Optional opt = Resources.images().tryGet(cacheKey);
        if (opt.isPresent()) {
            return (BufferedImage)opt.get();
        }
        BufferedImage img = ImageProcessing.getCompatibleImage((int)map.getSizeInPixels().getWidth(), (int)map.getSizeInPixels().getHeight());
        Graphics2D g = img.createGraphics();
        for (ITileLayer layer : map.getTileLayers()) {
            if (layer == null || !MapRenderer.shouldBeRendered(layer, renderTypes)) continue;
            ImageRenderer.render(g, this.getLayerImage(layer, map, true), layer.getOffset());
        }
        g.dispose();
        Resources.images().add(cacheKey, img);
        return img;
    }

    @Override
    public BufferedImage getImage(IMap map) {
        return this.getImage(map, RenderType.BACKGROUND, RenderType.GROUND, RenderType.SURFACE, RenderType.NORMAL, RenderType.OVERLAY);
    }

    @Override
    public void render(Graphics2D g, IMap map, RenderType ... renderTypes) {
        this.render(g, map, 0.0, 0.0, renderTypes);
    }

    @Override
    public void render(Graphics2D g, IMap map, double offsetX, double offsetY, RenderType ... renderTypes) {
        BufferedImage mapImage = this.getImage(map, renderTypes);
        ImageRenderer.render(g, mapImage, offsetX, offsetY);
    }

    protected abstract BufferedImage getLayerImage(ITileLayer var1, IMap var2, boolean var3);

    protected abstract void renderTileLayerImage(Graphics2D var1, ITileLayer var2, IMap var3, Rectangle2D var4);

    protected static boolean shouldBeRendered(ILayer layer, RenderType[] renderTypes) {
        if (renderTypes == null || renderTypes.length == 0) {
            return MapRenderer.isVisible(layer);
        }
        for (RenderType alloc : renderTypes) {
            if (alloc != layer.getRenderType()) continue;
            return MapRenderer.isVisible(layer);
        }
        return false;
    }

    protected static boolean isVisible(ILayer layer) {
        return layer.isVisible() && layer.getOpacity() > 0.0f;
    }

    protected static void renderImageLayer(Graphics2D g, IImageLayer layer, Rectangle2D viewport) {
        Spritesheet sprite = Resources.spritesheets().get(layer.getImage().getSource());
        if (sprite == null) {
            return;
        }
        Composite oldComp = g.getComposite();
        AlphaComposite ac = AlphaComposite.getInstance(3, layer.getOpacity());
        g.setComposite(ac);
        double viewportOffsetX = -viewport.getX() + (double)layer.getOffset().x;
        double viewportOffsetY = -viewport.getY() + (double)layer.getOffset().y;
        ImageRenderer.render(g, sprite.getImage(), viewportOffsetX, viewportOffsetY);
        g.setComposite(oldComp);
    }

    protected static String getCacheKey(IMap map) {
        return "map_" + map.getName();
    }

    protected static Image getTileImage(IMap map, ITile tile) {
        if (tile == null) {
            return null;
        }
        ITileset tileset = MapUtilities.findTileSet(map, tile);
        if (tileset == null || tileset.getFirstGridId() > tile.getGridId()) {
            return null;
        }
        Spritesheet sprite = tileset.getSpritesheet();
        if (sprite == null) {
            return null;
        }
        int index = tile.getGridId() - tileset.getFirstGridId();
        ITileAnimation animation = MapUtilities.getAnimation(map, index);
        if (animation != null && !animation.getFrames().isEmpty()) {
            long playedMs = Game.time().sinceGameStart();
            int totalDuration = animation.getTotalDuration();
            long animationsPlayed = playedMs / (long)totalDuration;
            long deltaTicks = playedMs - animationsPlayed * (long)totalDuration;
            int currentPlayTime = 0;
            for (ITileAnimationFrame frame : animation.getFrames()) {
                if (deltaTicks >= (long)(currentPlayTime += frame.getDuration())) continue;
                index = frame.getTileId();
                break;
            }
        }
        BufferedImage tileImage = sprite.getSprite(index, tileset.getMargin(), tileset.getSpacing());
        if (tile.isFlipped()) {
            if (tile.isFlippedDiagonally()) {
                tileImage = ImageProcessing.rotate(tileImage, -1.5707963267948966);
                tileImage = ImageProcessing.verticalFlip(tileImage);
            }
            if (tile.isFlippedHorizontally()) {
                tileImage = ImageProcessing.horizontalFlip(tileImage);
            }
            if (tile.isFlippedVertically()) {
                tileImage = ImageProcessing.verticalFlip(tileImage);
            }
        }
        return tileImage;
    }
}

