/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap;

import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.ITileLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITileOffset;
import de.gurkenlabs.litiengine.environment.tilemap.MapOrientation;
import de.gurkenlabs.litiengine.environment.tilemap.MapRenderer;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Optional;

public class HexagonalMapRenderer
extends MapRenderer {
    @Override
    public MapOrientation getSupportedOrientation() {
        return MapOrientation.HEXAGONAL;
    }

    @Override
    protected synchronized BufferedImage getLayerImage(ITileLayer layer, IMap map, boolean includeAnimationTiles) {
        String cacheKey = HexagonalMapRenderer.getCacheKey(map) + "_" + layer.getName();
        Optional opt = Resources.images().tryGet(cacheKey);
        if (opt.isPresent()) {
            return (BufferedImage)opt.get();
        }
        BufferedImage bufferedImage = ImageProcessing.getCompatibleImage(map.getSizeInPixels().width, map.getSizeInPixels().height);
        Graphics2D imageGraphics = bufferedImage.createGraphics();
        AlphaComposite ac = AlphaComposite.getInstance(3, layer.getOpacity());
        imageGraphics.setComposite(ac);
        for (int y = 0; y < layer.getSizeInTiles().height; ++y) {
            for (int x = 0; x < layer.getSizeInTiles().width; ++x) {
                ITile tile = layer.getTile(x, y);
                Rectangle tileBounds = map.getTileShape(x, y).getBounds();
                if (tile == null || !includeAnimationTiles && MapUtilities.hasAnimation(map, tile)) continue;
                Image tileTexture = HexagonalMapRenderer.getTileImage(map, tile);
                int tileOffsetX = 0;
                int tileOffsetY = 0;
                ITileOffset tileOffset = MapUtilities.findTileSet(map, tile).getTileOffset();
                if (tileOffset != null) {
                    tileOffsetX = tileOffset.getX();
                    tileOffsetY = tileOffset.getY();
                }
                double offsetX = layer.getOffset().x;
                double offsetY = layer.getOffset().y;
                ImageRenderer.render(imageGraphics, tileTexture, offsetX + tileBounds.getX() + (double)(tileOffsetX -= MapUtilities.findTileSet(map, tile).getTileWidth() - map.getTileWidth()), offsetY + tileBounds.getY() + (double)(tileOffsetY -= MapUtilities.findTileSet(map, tile).getTileHeight() - map.getTileHeight()));
            }
        }
        Resources.images().add(cacheKey, bufferedImage);
        return bufferedImage;
    }

    @Override
    protected void renderTileLayerImage(Graphics2D g, ITileLayer layer, IMap map, Rectangle2D viewport) {
        Composite oldComp = g.getComposite();
        AlphaComposite ac = AlphaComposite.getInstance(3, layer.getOpacity());
        g.setComposite(ac);
        for (int x = 0; x < map.getWidth(); ++x) {
            for (int y = 0; y < map.getHeight(); ++y) {
                ITile tile = layer.getTile(x, y);
                Rectangle2D tileBounds = map.getTileShape(x, y).getBounds2D();
                if (tile == null || !viewport.intersects(tileBounds)) continue;
                Image tileTexture = HexagonalMapRenderer.getTileImage(map, tile);
                int tileOffsetX = 0;
                int tileOffsetY = 0;
                ITileOffset tileOffset = MapUtilities.findTileSet(map, tile).getTileOffset();
                if (tileOffset != null) {
                    tileOffsetX = tileOffset.getX();
                    tileOffsetY = tileOffset.getY();
                }
                double offsetX = -viewport.getX() + (double)layer.getOffset().x;
                double offsetY = -viewport.getY() + (double)layer.getOffset().y;
                ImageRenderer.render(g, tileTexture, offsetX + tileBounds.getX() + (double)(tileOffsetX -= MapUtilities.findTileSet(map, tile).getTileWidth() - map.getTileWidth()), offsetY + tileBounds.getY() + (double)(tileOffsetY -= MapUtilities.findTileSet(map, tile).getTileHeight() - map.getTileHeight()));
            }
        }
        g.setComposite(oldComp);
    }
}

