/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.attributes.AttributeModifier;
import de.gurkenlabs.litiengine.attributes.Modification;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.Material;
import de.gurkenlabs.litiengine.entities.Prop;
import de.gurkenlabs.litiengine.entities.Rotation;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.graphics.animation.EntityAnimationController;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropMapObjectLoader
extends MapObjectLoader {
    private static final Logger log = Logger.getLogger(PropMapObjectLoader.class.getName());
    private static final List<Class<? extends Prop>> customPropType = new CopyOnWriteArrayList<Class<? extends Prop>>();

    protected PropMapObjectLoader() {
        super(MapObjectType.PROP);
    }

    public static <T extends Prop> void registerCustomPropType(Class<T> propType) {
        customPropType.add(propType);
    }

    @Override
    public Collection<IEntity> load(IEnvironment environment, IMapObject mapObject) {
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.PROP) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + PropMapObjectLoader.class);
        }
        Prop prop = this.createNewProp(mapObject, mapObject.getStringValue("spritesheetName"));
        PropMapObjectLoader.loadDefaultProperties(prop, mapObject);
        PropMapObjectLoader.loadCollisionProperties(prop, mapObject);
        prop.setMaterial(mapObject.getEnumValue("material", Material.class, Material.UNDEFINED));
        prop.setObstacle(mapObject.getBoolValue("isObstacle"));
        prop.setSpriteRotation(mapObject.getEnumValue("rotationSprite", Rotation.class, Rotation.NONE));
        prop.setIndestructible(mapObject.getBoolValue("indestructible"));
        AttributeModifier mod = new AttributeModifier(Modification.SET, mapObject.getIntValue("health"));
        prop.getHitPoints().modifyMaxBaseValue(mod);
        prop.getHitPoints().modifyBaseValue(mod);
        prop.setAddShadow(mapObject.getBoolValue("addShadow"));
        prop.setFlipHorizontally(mapObject.getBoolValue("flipHorizontally"));
        prop.setFlipVertically(mapObject.getBoolValue("flipVertically"));
        prop.setScaling(mapObject.getBoolValue("scaling"));
        prop.setTeam(mapObject.getIntValue("team"));
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        entities.add(prop);
        return entities;
    }

    protected Prop createNewProp(IMapObject mapObject, String spriteSheet) {
        for (Class<? extends Prop> customProp : customPropType) {
            for (String prefix : EntityAnimationController.getDefaultSpritePrefixes(customProp)) {
                Prop created;
                if (prefix == null || !("prop-" + spriteSheet).equalsIgnoreCase(prefix) || (created = this.createCustomProp(customProp, spriteSheet)) == null) continue;
                return created;
            }
        }
        return new Prop(spriteSheet);
    }

    private Prop createCustomProp(Class<? extends Prop> customProp, String spriteSheet) {
        try {
            return customProp.getConstructor(String.class).newInstance(spriteSheet);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            try {
                Prop creature = customProp.getConstructor(new Class[0]).newInstance(new Object[0]);
                creature.setSpritesheetName(spriteSheet);
                return creature;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                log.log(Level.SEVERE, "Could not automatically create prop of type {0} because a matching constructor is missing.", new Object[]{customProp});
                log.log(Level.SEVERE, ex.getMessage(), ex);
                return null;
            }
        }
    }
}

