/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.MapArea;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import java.util.ArrayList;
import java.util.Collection;

public class MapAreaMapObjectLoader
extends MapObjectLoader {
    protected MapAreaMapObjectLoader() {
        super(MapObjectType.AREA);
    }

    @Override
    public Collection<IEntity> load(IEnvironment environment, IMapObject mapObject) {
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.AREA) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + MapAreaMapObjectLoader.class);
        }
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        MapArea mapArea = this.createMapArea(mapObject);
        MapAreaMapObjectLoader.loadDefaultProperties(mapArea, mapObject);
        entities.add(mapArea);
        return entities;
    }

    protected MapArea createMapArea(IMapObject mapObject) {
        return new MapArea();
    }
}

