/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObject;
import de.gurkenlabs.litiengine.graphics.emitters.particles.ParticleType;
import de.gurkenlabs.litiengine.graphics.emitters.xml.CustomEmitter;
import de.gurkenlabs.litiengine.graphics.emitters.xml.EmitterData;
import de.gurkenlabs.litiengine.graphics.emitters.xml.ParticleColor;
import de.gurkenlabs.litiengine.graphics.emitters.xml.ParticleParameter;
import de.gurkenlabs.litiengine.physics.CollisionType;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EmitterMapObjectLoader
extends MapObjectLoader {
    protected EmitterMapObjectLoader() {
        super(MapObjectType.EMITTER);
    }

    public static List<ParticleColor> getColors(IMapObject emitter) {
        ArrayList<ParticleColor> particleColors = new ArrayList<ParticleColor>();
        String colorsString = emitter.getStringValue("emitterColors", "");
        if (colorsString != null && !colorsString.isEmpty()) {
            String[] colors;
            for (String color : colors = colorsString.split(",")) {
                ParticleColor particleColor = ParticleColor.decode(color);
                if (particleColor == null) continue;
                particleColors.add(particleColor);
            }
        }
        return particleColors;
    }

    @Override
    public Collection<IEntity> load(IEnvironment environment, IMapObject mapObject) {
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.EMITTER) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + EmitterMapObjectLoader.class);
        }
        EmitterData data = EmitterMapObjectLoader.createEmitterData(mapObject);
        CustomEmitter emitter = this.createCustomEmitter(data);
        EmitterMapObjectLoader.loadDefaultProperties(emitter, mapObject);
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        entities.add(emitter);
        return entities;
    }

    protected CustomEmitter createCustomEmitter(EmitterData data) {
        return new CustomEmitter(data);
    }

    public static EmitterData createEmitterData(IMapObject mapObject) {
        EmitterData data = new EmitterData();
        data.setWidth(mapObject.getWidth());
        data.setHeight(mapObject.getHeight());
        data.setSpawnRate(mapObject.getIntValue("emitterSpawnRate"));
        data.setSpawnAmount(mapObject.getIntValue("emitterSpawnAmount"));
        data.setUpdateRate(mapObject.getIntValue("emitterUpdateDelay", 30));
        data.setEmitterTTL(mapObject.getIntValue("emitterTimeToLive"));
        data.setMaxParticles(mapObject.getIntValue("emitterMaxParticles"));
        data.setParticleType(mapObject.getEnumValue("emitterParticleType", ParticleType.class, ParticleType.RECTANGLE));
        data.setColorDeviation(mapObject.getFloatValue("emitterColorDeviation"));
        data.setAlphaDeviation(mapObject.getFloatValue("emitterAlphaDeviation"));
        data.setOriginAlign(mapObject.getEnumValue("emitterOriginAlign", Align.class, Align.LEFT));
        data.setOriginValign(mapObject.getEnumValue("emitterOriginValign", Valign.class, Valign.TOP));
        data.setColors(EmitterMapObjectLoader.getColors(mapObject));
        data.setColorProbabilities(mapObject.getStringValue("emitterColorProbabilities", ""));
        data.setParticleX(new ParticleParameter(mapObject.getFloatValue("particleMinX"), mapObject.getFloatValue("particleMaxX", -1.0f)));
        data.setParticleY(new ParticleParameter(mapObject.getFloatValue("particleMinY"), mapObject.getFloatValue("particleMaxY", -1.0f)));
        data.setParticleWidth(new ParticleParameter(mapObject.getFloatValue("particleMinStartWidth"), mapObject.getFloatValue("particleMaxStartWidth", -1.0f)));
        data.setParticleHeight(new ParticleParameter(mapObject.getFloatValue("particleMinStartHeight"), mapObject.getFloatValue("particleMaxStartHeight", -1.0f)));
        data.setDeltaX(new ParticleParameter(mapObject.getFloatValue("particleMinDeltaX"), mapObject.getFloatValue("particleMaxDeltaX", -1.0f)));
        data.setDeltaY(new ParticleParameter(mapObject.getFloatValue("particleMinDeltaY"), mapObject.getFloatValue("particleMaxDeltaY", -1.0f)));
        data.setGravityX(new ParticleParameter(mapObject.getFloatValue("particleMinGravityX"), mapObject.getFloatValue("particleMaxGravityX", -1.0f)));
        data.setGravityY(new ParticleParameter(mapObject.getFloatValue("particleMinGravityY"), mapObject.getFloatValue("particleMaxGravityY", -1.0f)));
        data.setDeltaWidth(new ParticleParameter(mapObject.getFloatValue("particleMinDeltaWidth"), mapObject.getFloatValue("particleMaxDeltaWidth", -1.0f)));
        data.setDeltaHeight(new ParticleParameter(mapObject.getFloatValue("particleMinDeltaHeight"), mapObject.getFloatValue("particleMaxDeltaHeight", -1.0f)));
        data.setParticleMinTTL(mapObject.getIntValue("particleMinTTL"));
        data.setParticleMaxTTL(mapObject.getIntValue("particleMaxTTL"));
        data.setCollisionType(mapObject.getEnumValue("particlePhysics", CollisionType.class, CollisionType.NONE));
        data.setParticleText(mapObject.getStringValue("particleText"));
        data.setSpritesheet(mapObject.getStringValue("particleSprite"));
        data.setAnimateSprite(mapObject.getBoolValue("particleAnimateSprite"));
        data.setFade(mapObject.getBoolValue("particleFade"));
        return data;
    }

    public static IMapObject createMapObject(EmitterData emitterData) {
        MapObject newMapObject = new MapObject();
        newMapObject.setType(MapObjectType.EMITTER.toString());
        newMapObject.setWidth(emitterData.getWidth());
        newMapObject.setHeight(emitterData.getHeight());
        newMapObject.setValue("emitterSpawnRate", emitterData.getSpawnRate());
        newMapObject.setValue("emitterSpawnAmount", emitterData.getSpawnAmount());
        newMapObject.setValue("emitterUpdateDelay", emitterData.getUpdateRate());
        newMapObject.setValue("emitterTimeToLive", emitterData.getEmitterTTL());
        newMapObject.setValue("emitterMaxParticles", emitterData.getMaxParticles());
        newMapObject.setValue("emitterParticleType", emitterData.getParticleType());
        newMapObject.setValue("emitterColorDeviation", emitterData.getColorDeviation());
        newMapObject.setValue("emitterAlphaDeviation", emitterData.getAlphaDeviation());
        newMapObject.setValue("emitterOriginAlign", emitterData.getOriginAlign());
        newMapObject.setValue("emitterOriginValign", emitterData.getOriginValign());
        String commaSeperatedColors = ArrayUtilities.join(emitterData.getColors());
        newMapObject.setValue("emitterColors", commaSeperatedColors);
        newMapObject.setValue("emitterParticleType", ArrayUtilities.join(emitterData.getColorProbabilities()));
        newMapObject.setValue("particleMinX", emitterData.getParticleX().getMinValue());
        newMapObject.setValue("particleMinY", emitterData.getParticleY().getMinValue());
        newMapObject.setValue("particleMinStartWidth", emitterData.getParticleWidth().getMinValue());
        newMapObject.setValue("particleMinStartHeight", emitterData.getParticleHeight().getMinValue());
        newMapObject.setValue("particleMinDeltaX", emitterData.getDeltaX().getMinValue());
        newMapObject.setValue("particleMinDeltaY", emitterData.getDeltaY().getMinValue());
        newMapObject.setValue("particleMinGravityX", emitterData.getGravityX().getMinValue());
        newMapObject.setValue("particleMinGravityY", emitterData.getGravityY().getMinValue());
        newMapObject.setValue("particleMinDeltaWidth", emitterData.getDeltaWidth().getMinValue());
        newMapObject.setValue("particleMinDeltaHeight", emitterData.getDeltaHeight().getMinValue());
        newMapObject.setValue("particleMaxX", emitterData.getParticleX().getMaxValue());
        newMapObject.setValue("particleMaxY", emitterData.getParticleY().getMaxValue());
        newMapObject.setValue("particleMaxStartWidth", emitterData.getParticleWidth().getMaxValue());
        newMapObject.setValue("particleMaxStartHeight", emitterData.getParticleHeight().getMaxValue());
        newMapObject.setValue("particleMaxDeltaX", emitterData.getDeltaX().getMaxValue());
        newMapObject.setValue("particleMaxDeltaY", emitterData.getDeltaY().getMaxValue());
        newMapObject.setValue("particleMaxGravityX", emitterData.getGravityX().getMaxValue());
        newMapObject.setValue("particleMaxGravityY", emitterData.getGravityY().getMaxValue());
        newMapObject.setValue("particleMaxDeltaWidth", emitterData.getDeltaWidth().getMaxValue());
        newMapObject.setValue("particleMaxDeltaHeight", emitterData.getDeltaHeight().getMaxValue());
        newMapObject.setValue("particleMinTTL", emitterData.getParticleMinTTL());
        newMapObject.setValue("particleMaxTTL", emitterData.getParticleMaxTTL());
        newMapObject.setValue("particlePhysics", emitterData.getCollisionType());
        newMapObject.setValue("particleText", emitterData.getParticleText());
        newMapObject.setValue("particleSprite", emitterData.getSpritesheet());
        newMapObject.setValue("particleAnimateSprite", emitterData.isAnimateSprite());
        newMapObject.setValue("particleFade", emitterData.isFading());
        return newMapObject;
    }
}

