/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.MapObjectException;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;

public final class CustomMapObjectLoader
extends MapObjectLoader {
    private final ConstructorInvocation invoke;

    protected CustomMapObjectLoader(String mapObjectType, Class<? extends IEntity> entityType) {
        super(mapObjectType);
        if (entityType.isInterface() || Modifier.isAbstract(entityType.getModifiers())) {
            throw new IllegalArgumentException("cannot create loader for interface or abstract class");
        }
        ConstructorInvocation invoke = null;
        Constructor<?>[] constructors = entityType.getConstructors();
        int priority = 0;
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> constructor = constructors[i];
            Class<?>[] classes = constructor.getParameterTypes();
            if (classes.length == 2) {
                if (classes[0] == IEnvironment.class && classes[1] == IMapObject.class) {
                    invoke = (e, o) -> (IEntity)constructor.newInstance(e, o);
                    break;
                }
                if (classes[0] != IMapObject.class || classes[1] != IEnvironment.class) continue;
                invoke = (e, o) -> (IEntity)constructor.newInstance(o, e);
                priority = 3;
                continue;
            }
            if (classes.length == 1) {
                if (priority >= 3) continue;
                if (classes[0] == IMapObject.class) {
                    invoke = (e, o) -> (IEntity)constructor.newInstance(o);
                    priority = 2;
                    continue;
                }
                if (priority >= 2 || classes[0] != IEnvironment.class) continue;
                invoke = (e, o) -> (IEntity)constructor.newInstance(e);
                priority = 1;
                continue;
            }
            if (classes.length != 0 || priority >= 1) continue;
            invoke = (e, o) -> (IEntity)constructor.newInstance(new Object[0]);
        }
        if (invoke == null) {
            throw new IllegalArgumentException("could not find suitable constructor");
        }
        this.invoke = invoke;
    }

    @Override
    public Collection<IEntity> load(IEnvironment environment, IMapObject mapObject) throws MapObjectException {
        IEntity entity;
        try {
            entity = this.invoke.invoke(environment, mapObject);
        }
        catch (ReflectiveOperationException e) {
            throw new MapObjectException(e);
        }
        CustomMapObjectLoader.loadDefaultProperties(entity, mapObject);
        if (entity instanceof ICollisionEntity) {
            CustomMapObjectLoader.loadCollisionProperties((ICollisionEntity)entity, mapObject);
        }
        return Arrays.asList(entity);
    }

    @FunctionalInterface
    private static interface ConstructorInvocation {
        public IEntity invoke(IEnvironment var1, IMapObject var2) throws InvocationTargetException, IllegalAccessException, InstantiationException;
    }
}

