/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.Direction;
import de.gurkenlabs.litiengine.entities.Creature;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.graphics.animation.EntityAnimationController;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CreatureMapObjectLoader
extends MapObjectLoader {
    private static final Logger log = Logger.getLogger(CreatureMapObjectLoader.class.getName());
    private static final List<Class<? extends Creature>> customCreatureType = new CopyOnWriteArrayList<Class<? extends Creature>>();

    protected CreatureMapObjectLoader() {
        super(MapObjectType.CREATURE);
    }

    public static <T extends Creature> void registerCustomCreatureType(Class<T> creatureType) {
        customCreatureType.add(creatureType);
    }

    @Override
    public Collection<IEntity> load(IEnvironment environment, IMapObject mapObject) {
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.CREATURE) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + CreatureMapObjectLoader.class);
        }
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        String spriteSheet = mapObject.getStringValue("spritesheetName");
        if (spriteSheet == null) {
            return entities;
        }
        Creature creature = this.createNewCreature(mapObject, spriteSheet, mapObject.getStringValue("spawnType"));
        CreatureMapObjectLoader.loadDefaultProperties(creature, mapObject);
        CreatureMapObjectLoader.loadCollisionProperties(creature, mapObject);
        creature.setFacingDirection(mapObject.getEnumValue("spawnDirection", Direction.class, Direction.RIGHT));
        entities.add(creature);
        return entities;
    }

    protected Creature createNewCreature(IMapObject mapObject, String spriteSheet, String spawnType) {
        for (Class<? extends Creature> customCreature : customCreatureType) {
            for (String prefix : EntityAnimationController.getDefaultSpritePrefixes(customCreature)) {
                Creature created;
                if (prefix == null || !spriteSheet.equalsIgnoreCase(prefix) || (created = this.createCustomCreature(customCreature, spriteSheet)) == null) continue;
                return created;
            }
        }
        return new Creature(spriteSheet);
    }

    private Creature createCustomCreature(Class<? extends Creature> customCreature, String spriteSheet) {
        try {
            return customCreature.getConstructor(String.class).newInstance(spriteSheet);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            try {
                Creature creature = customCreature.getConstructor(new Class[0]).newInstance(new Object[0]);
                creature.setSpritePrefix(spriteSheet);
                return creature;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                log.log(Level.WARNING, "Could not automatically create creature of type {0} because a matching constructor is missing.", new Object[]{customCreature});
                log.log(Level.SEVERE, ex.getMessage(), ex);
                return null;
            }
        }
    }
}

