/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.annotation.CollisionInfo;
import de.gurkenlabs.litiengine.annotation.EntityInfo;
import de.gurkenlabs.litiengine.entities.CollisionEntity;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.TriggerActivatedListener;
import de.gurkenlabs.litiengine.entities.TriggerActivatingCondition;
import de.gurkenlabs.litiengine.entities.TriggerDeactivatedListener;
import de.gurkenlabs.litiengine.entities.TriggerEvent;
import de.gurkenlabs.litiengine.entities.TriggerListener;
import de.gurkenlabs.litiengine.environment.tilemap.ICustomPropertyProvider;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

@CollisionInfo(collision=false)
@EntityInfo(renderType=RenderType.OVERLAY)
public class Trigger
extends CollisionEntity
implements IUpdateable {
    public static final String INTERACT_MESSAGE = "interact";
    private static final Logger log = Logger.getLogger(Trigger.class.getName());
    private List<IEntity> activated;
    private final Collection<TriggerActivatedListener> activatedListeners;
    private final Collection<TriggerDeactivatedListener> deactivatedListeners;
    private final Collection<TriggerActivatingCondition> activatingConditions = new CopyOnWriteArrayList<TriggerActivatingCondition>();
    @TmxProperty(name="triggerActivators")
    private final List<Integer> activators;
    @TmxProperty(name="triggerTarget")
    private final List<Integer> targets;
    @TmxProperty(name="triggerActivation")
    private final TriggerActivation activationType;
    @TmxProperty(name="triggerOneTime")
    private final boolean isOneTimeTrigger;
    @TmxProperty(name="triggermessage")
    private String message;
    @TmxProperty(name="triggerCooldown")
    private int cooldown;
    private long lastActivation;
    private boolean isActivated;

    public Trigger(TriggerActivation activation, String message) {
        this(activation, null, message);
    }

    public Trigger(TriggerActivation activation, String name, String message) {
        this(activation, name, message, false, null);
    }

    public Trigger(TriggerActivation activation, String message, boolean isOneTime, ICustomPropertyProvider customProperties) {
        this.activatedListeners = new CopyOnWriteArrayList<TriggerActivatedListener>();
        this.deactivatedListeners = new CopyOnWriteArrayList<TriggerDeactivatedListener>();
        this.activators = new CopyOnWriteArrayList<Integer>();
        this.targets = new CopyOnWriteArrayList<Integer>();
        this.activated = new CopyOnWriteArrayList<IEntity>();
        this.message = message;
        this.isOneTimeTrigger = isOneTime;
        this.activationType = activation;
        this.setProperties(customProperties);
    }

    public Trigger(TriggerActivation activation, String name, String message, boolean isOneTime, ICustomPropertyProvider customProperties) {
        this(activation, message, isOneTime, customProperties);
        this.setName(name);
    }

    public Trigger(TriggerActivation activation, String message, boolean isOneTime, int cooldown, ICustomPropertyProvider customProperties) {
        this(activation, message, isOneTime, customProperties);
        this.setCooldown(cooldown);
    }

    public void addTriggerListener(TriggerListener listener) {
        this.activatedListeners.add(listener);
        this.activatingConditions.add(listener);
        this.deactivatedListeners.add(listener);
    }

    public void removeTriggerListener(TriggerListener listener) {
        this.activatedListeners.remove(listener);
        this.activatingConditions.remove(listener);
        this.deactivatedListeners.remove(listener);
    }

    public void addActivatedListener(TriggerActivatedListener listener) {
        this.activatedListeners.add(listener);
    }

    public void removeActivatedListener(TriggerActivatedListener listener) {
        this.activatedListeners.remove(listener);
    }

    public void addActivatingCondition(TriggerActivatingCondition condition) {
        this.activatingConditions.add(condition);
    }

    public void removeActivatingCondition(TriggerActivatingCondition condition) {
        this.activatingConditions.remove(condition);
    }

    public void addDeactivatedListener(TriggerDeactivatedListener listener) {
        this.deactivatedListeners.add(listener);
    }

    public void removeDeactivatedListener(TriggerDeactivatedListener listener) {
        this.deactivatedListeners.remove(listener);
    }

    public void addActivator(int mapId) {
        this.activators.add(mapId);
    }

    public void addTarget(int mapId) {
        this.targets.add(mapId);
    }

    public TriggerActivation getActivationType() {
        return this.activationType;
    }

    public List<Integer> getActivators() {
        return this.activators;
    }

    public String getMessage() {
        return this.message;
    }

    public List<Integer> getTargets() {
        return this.targets;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean canTrigger(ICollisionEntity entity) {
        return entity.canCollideWith(this) && GeometricUtilities.intersects(this.getCollisionBox(), entity.getCollisionBox());
    }

    public boolean isOneTimeTrigger() {
        return this.isOneTimeTrigger;
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    @Override
    public String sendMessage(Object sender, String message) {
        if (this.activationType == TriggerActivation.COLLISION && sender != null && sender instanceof IEntity || message == null || message.isEmpty()) {
            return Boolean.toString(false);
        }
        if (!message.equals(INTERACT_MESSAGE)) {
            return Boolean.toString(false);
        }
        if (sender instanceof IEntity) {
            IEntity ent = (IEntity)sender;
            if (this.activators.isEmpty() || this.activators.contains(ent.getMapId())) {
                this.activate(ent, ent.getMapId());
                return Boolean.toString(true);
            }
            log.log(Level.INFO, "[{1}] tried to activate trigger [{0}] but was not allowed so because it was not on the list of activators", new Object[]{this.getName(), ent.getMapId()});
            return Boolean.toString(false);
        }
        return super.sendMessage(sender, message);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void setHeight(float height) {
        this.setCollisionBoxHeight(height);
        super.setHeight(height);
    }

    @Override
    public void setWidth(float width) {
        this.setCollisionBoxWidth(width);
        super.setWidth(width);
    }

    @Override
    public void setSize(float width, float height) {
        this.setCollisionBoxWidth(width);
        this.setCollisionBoxHeight(height);
        super.setSize(width, height);
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public void update() {
        if (Game.world().environment() == null || this.activationType != TriggerActivation.COLLISION) {
            return;
        }
        List<IEntity> collEntities = this.getEntitiesInCollisionBox();
        for (IEntity ent : collEntities) {
            if (this.activated.contains(ent)) continue;
            this.activate(ent, ent.getMapId());
        }
        for (IEntity ent : this.activated) {
            if (collEntities.contains(ent)) continue;
            List<Integer> triggerTargets = this.getTargets();
            if (triggerTargets.isEmpty()) {
                triggerTargets = new ArrayList<Integer>();
                triggerTargets.add(ent.getMapId());
            }
            TriggerEvent event = new TriggerEvent(this, ent, triggerTargets);
            for (TriggerDeactivatedListener listener : this.deactivatedListeners) {
                listener.deactivated(event);
            }
        }
        this.activated = collEntities;
    }

    private boolean activate(IEntity activator, int tar) {
        if (this.isOneTimeTrigger && this.isActivated || this.getActivationType() == TriggerActivation.COLLISION && activator != null && this.activated.contains(activator)) {
            return false;
        }
        if (this.cooldown > 0 && Game.loop().getDeltaTime(this.lastActivation) < (long)this.cooldown) {
            return false;
        }
        List<Integer> triggerTargets = this.getTargets(tar);
        TriggerEvent te = new TriggerEvent(this, activator, triggerTargets);
        if (!this.checkActivationPredicates(te)) {
            return false;
        }
        this.isActivated = true;
        if (!triggerTargets.isEmpty()) {
            Iterator<Object> iterator = triggerTargets.iterator();
            while (iterator.hasNext()) {
                int target = (Integer)iterator.next();
                IEntity entity = Game.world().environment().get(target);
                if (entity == null) {
                    log.log(Level.WARNING, "trigger [{0}] was activated, but the trigger target [{1}] could not be found on the environment", new Object[]{this.getName(), target});
                    continue;
                }
                entity.sendMessage(this, this.message);
                this.activated.add(activator);
            }
        }
        for (TriggerActivatedListener listener : this.activatedListeners) {
            listener.activated(te);
        }
        if (this.isOneTimeTrigger && this.isActivated) {
            Game.world().environment().remove(this);
        }
        this.lastActivation = Game.loop().getTicks();
        return true;
    }

    private boolean checkActivationPredicates(TriggerEvent te) {
        for (TriggerActivatingCondition condition : this.activatingConditions) {
            String result = condition.canActivate(te);
            if (result == null || result.isEmpty()) continue;
            te.getEntity().sendMessage(this, result);
            return false;
        }
        return true;
    }

    private List<IEntity> getEntitiesInCollisionBox() {
        CopyOnWriteArrayList<IEntity> collEntities = new CopyOnWriteArrayList<IEntity>();
        for (ICollisionEntity coll : Game.physics().getCollisionEntities()) {
            if (coll == this || !this.activators.isEmpty() && !this.activators.contains(coll.getMapId()) || !coll.getCollisionBox().intersects(this.getCollisionBox())) continue;
            collEntities.add(coll);
        }
        return collEntities;
    }

    private List<Integer> getTargets(int optionalTarget) {
        List<Integer> localTargets = this.getTargets();
        if (localTargets.isEmpty()) {
            localTargets = new ArrayList<Integer>();
            if (optionalTarget > 0) {
                localTargets.add(optionalTarget);
            }
        }
        return localTargets;
    }

    public static enum TriggerActivation {
        COLLISION,
        INTERACT;

    }
}

