/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Direction;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.Entity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import java.awt.geom.Point2D;

public class Spawnpoint
extends Entity {
    @TmxProperty(name="spawnDirection")
    private Direction direction;
    @TmxProperty(name="spawnType")
    private String spawnType;

    public Spawnpoint() {
    }

    public Spawnpoint(double x, double y) {
        this(0, x, y);
    }

    public Spawnpoint(int mapId, double x, double y) {
        this(mapId, new Point2D.Double(x, y));
    }

    public Spawnpoint(int mapId, Point2D point) {
        super(mapId);
        this.setLocation(point);
    }

    public Spawnpoint(int mapId, double x, double y, Direction direction) {
        this(mapId, new Point2D.Double(x, y), direction);
    }

    public Spawnpoint(int mapId, Point2D point, Direction direction) {
        this(mapId, point);
        this.setDirection(direction);
    }

    public Spawnpoint(Direction direction) {
        this.setDirection(direction);
    }

    public Spawnpoint(Direction direction, String spawnType) {
        this(direction);
        this.setSpawnType(spawnType);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public String getSpawnType() {
        return this.spawnType;
    }

    public void setSpawnType(String spawnType) {
        this.spawnType = spawnType;
    }

    public void spawn(IMobileEntity entity) {
        entity.setLocation(this.getLocation());
        entity.setAngle(Direction.toAngle(this.getDirection()));
        IEnvironment env = this.getEnvironment();
        if (env == null) {
            env = Game.world().environment();
        }
        if (env != null && env.get(entity.getMapId()) == null) {
            env.add(entity);
        }
    }
}

