/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.entities.IEntityController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class EntityControllers {
    private Map<Class<? extends IEntityController>, IEntityController> controllers = new ConcurrentHashMap<Class<? extends IEntityController>, IEntityController>();

    public <T extends IEntityController> T getController(Class<T> clss) {
        T explicitController = this.getExplicitController(clss);
        if (explicitController != null) {
            return explicitController;
        }
        for (IEntityController controller : this.controllers.values()) {
            if (!clss.isInstance(controller)) continue;
            return (T)controller;
        }
        return null;
    }

    public <T extends IEntityController> void clearControllers(Class<T> clss) {
        this.controllers.entrySet().removeIf(e -> clss.isAssignableFrom((Class)e.getKey()));
    }

    public <T extends IEntityController> void addController(T controller) {
        this.controllers.put(controller.getClass(), controller);
    }

    public <T extends IEntityController> void setController(Class<T> clss, T controller) {
        this.clearControllers(clss);
        this.addController(controller);
    }

    public void detachAll() {
        for (IEntityController controller : this.controllers.values()) {
            controller.detach();
        }
    }

    public void attachAll() {
        for (IEntityController controller : this.controllers.values()) {
            controller.attach();
        }
    }

    private <T extends IEntityController> T getExplicitController(Class<T> clss) {
        IEntityController controller;
        if (this.controllers.containsKey(clss) && (controller = this.controllers.get(clss)) != null && clss.isInstance(controller)) {
            return (T)this.controllers.get(clss);
        }
        return null;
    }
}

