/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Direction;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.annotation.MovementInfo;
import de.gurkenlabs.litiengine.attributes.Attribute;
import de.gurkenlabs.litiengine.entities.CombatEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.entities.MobileEntity;
import de.gurkenlabs.litiengine.graphics.animation.CreatureAnimationController;
import de.gurkenlabs.litiengine.graphics.animation.EntityAnimationController;
import de.gurkenlabs.litiengine.physics.IMovementController;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.Point2D;

@MovementInfo
public class Creature
extends CombatEntity
implements IMobileEntity {
    private static final int IDLE_DELAY = 100;
    private int acceleration;
    private int deceleration;
    private long lastMoved;
    private Point2D moveDestination;
    private boolean turnOnMove;
    private Attribute<Float> velocity;
    private String spritePrefix;

    public Creature() {
        this(null);
    }

    public Creature(String spritePrefix) {
        MovementInfo movementInfo = this.getClass().getAnnotation(MovementInfo.class);
        if (movementInfo != null) {
            this.velocity = new Attribute<Float>(Float.valueOf(movementInfo.velocity()));
            this.acceleration = movementInfo.acceleration();
            this.deceleration = movementInfo.deceleration();
            this.setTurnOnMove(movementInfo.turnOnMove());
        }
        if (spritePrefix != null) {
            this.setSpritePrefix(spritePrefix);
        } else {
            this.setSpritePrefix(ArrayUtilities.getRandom(EntityAnimationController.getDefaultSpritePrefixes(this.getClass())));
        }
        this.addController(new CreatureAnimationController<Creature>(this, true));
    }

    @Override
    public int getAcceleration() {
        return this.acceleration;
    }

    @Override
    public int getDeceleration() {
        return this.deceleration;
    }

    public Direction getFacingDirection() {
        return Direction.fromAngle(this.getAngle());
    }

    @Override
    public Point2D getMoveDestination() {
        return this.moveDestination;
    }

    @Override
    public IMovementController getMovementController() {
        return this.getController(IMovementController.class);
    }

    public String getSpritePrefix() {
        return this.spritePrefix;
    }

    @Override
    public float getTickVelocity() {
        return MobileEntity.getTickVelocity(this);
    }

    @Override
    public Attribute<Float> getVelocity() {
        return this.velocity;
    }

    public boolean isIdle() {
        return Game.loop().getDeltaTime(this.lastMoved) > 100L;
    }

    @Override
    public void setAcceleration(int acceleration) {
        this.acceleration = acceleration;
    }

    @Override
    public void setDeceleration(int deceleration) {
        this.deceleration = deceleration;
    }

    public void setFacingDirection(Direction facingDirection) {
        this.setAngle(Direction.toAngle(facingDirection));
    }

    @Override
    public void setLocation(Point2D position) {
        if (this.isDead() || position == null || GeometricUtilities.equals(position, this.getLocation(), 0.001)) {
            return;
        }
        super.setLocation(position);
        if (Game.hasStarted()) {
            this.lastMoved = Game.loop().getTicks();
        }
    }

    @Override
    public void setMoveDestination(Point2D dest) {
        this.moveDestination = dest;
        this.setAngle(GeometricUtilities.calcRotationAngleInDegrees(this.getLocation(), this.getMoveDestination()));
    }

    @Override
    public void setTurnOnMove(boolean turn) {
        this.turnOnMove = turn;
    }

    public void setSpritePrefix(String spritePrefix) {
        this.spritePrefix = spritePrefix;
    }

    @Override
    public boolean turnOnMove() {
        return this.turnOnMove;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null && !this.getName().isEmpty()) {
            sb.append(this.getName());
        } else {
            sb.append(Creature.class.getSimpleName());
        }
        sb.append(" (");
        sb.append(this.getSpritePrefix());
        sb.append(") #");
        sb.append(this.getMapId());
        return sb.toString();
    }
}

