/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.abilities.Ability;
import de.gurkenlabs.litiengine.abilities.effects.IEffect;
import de.gurkenlabs.litiengine.annotation.CollisionInfo;
import de.gurkenlabs.litiengine.annotation.CombatInfo;
import de.gurkenlabs.litiengine.attributes.AttributeModifier;
import de.gurkenlabs.litiengine.attributes.Modification;
import de.gurkenlabs.litiengine.attributes.RangeAttribute;
import de.gurkenlabs.litiengine.entities.CollisionEntity;
import de.gurkenlabs.litiengine.entities.CombatEntityDeathListener;
import de.gurkenlabs.litiengine.entities.CombatEntityHitEvent;
import de.gurkenlabs.litiengine.entities.CombatEntityHitListener;
import de.gurkenlabs.litiengine.entities.CombatEntityListener;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import java.awt.geom.Ellipse2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@CombatInfo
@CollisionInfo(collision=true)
public class CombatEntity
extends CollisionEntity
implements ICombatEntity {
    private final List<IEffect> appliedEffects;
    private final List<CombatEntityListener> listeners = new CopyOnWriteArrayList<CombatEntityListener>();
    private final List<CombatEntityDeathListener> deathListeners = new CopyOnWriteArrayList<CombatEntityDeathListener>();
    private final List<CombatEntityHitListener> hitListeners = new CopyOnWriteArrayList<CombatEntityHitListener>();
    private final RangeAttribute<Integer> hitPoints;
    @TmxProperty(name="indestructible")
    private boolean isIndestructible;
    @TmxProperty(name="team")
    private int team;
    private ICombatEntity target;
    private long lastHit;

    public CombatEntity() {
        this.appliedEffects = new CopyOnWriteArrayList<IEffect>();
        CombatInfo info = this.getClass().getAnnotation(CombatInfo.class);
        this.hitPoints = new RangeAttribute<Integer>(info.hitpoints(), 0, info.hitpoints());
        this.setIndestructible(false);
    }

    @Override
    public void addCombatEntityListener(CombatEntityListener listener) {
        this.listeners.add(listener);
        this.hitListeners.add(listener);
        this.deathListeners.add(listener);
    }

    @Override
    public void removeCombatEntityListener(CombatEntityListener listener) {
        this.listeners.remove(listener);
        this.hitListeners.remove(listener);
        this.deathListeners.remove(listener);
    }

    @Override
    public void addHitListener(CombatEntityHitListener listener) {
        this.hitListeners.add(listener);
    }

    @Override
    public void removeHitListener(CombatEntityHitListener listener) {
        this.hitListeners.remove(listener);
    }

    @Override
    public void addDeathListener(CombatEntityDeathListener listener) {
        this.deathListeners.add(listener);
    }

    @Override
    public void removeDeathListener(CombatEntityDeathListener listener) {
        this.deathListeners.remove(listener);
    }

    @Override
    public void die() {
        if (this.isDead()) {
            return;
        }
        this.getHitPoints().modifyBaseValue(new AttributeModifier(Modification.SET, 0.0));
        this.fireDeathEvent();
        this.setCollision(false);
    }

    @Override
    public List<IEffect> getAppliedEffects() {
        return this.appliedEffects;
    }

    @Override
    public RangeAttribute<Integer> getHitPoints() {
        return this.hitPoints;
    }

    @Override
    public Ellipse2D getHitBox() {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public ICombatEntity getTarget() {
        return this.target;
    }

    @Override
    public int getTeam() {
        return this.team;
    }

    @Override
    public boolean hit(int damage) {
        return this.hit(damage, null);
    }

    @Override
    public boolean hit(int damage, Ability ability) {
        if (this.isDead()) {
            return false;
        }
        if (!this.isIndestructible()) {
            this.getHitPoints().modifyBaseValue(new AttributeModifier(Modification.SUBSTRACT, damage));
        }
        if (this.isDead()) {
            this.fireDeathEvent();
            this.setCollision(false);
        }
        CombatEntityHitEvent event = new CombatEntityHitEvent(this, damage, ability);
        for (CombatEntityHitListener listener : this.hitListeners) {
            listener.onHit(event);
        }
        this.lastHit = Game.loop().getTicks();
        return this.isDead();
    }

    private void fireDeathEvent() {
        for (CombatEntityDeathListener listener : this.deathListeners) {
            listener.onDeath(this);
        }
    }

    @Override
    public boolean isDead() {
        return this.getHitPoints().getCurrentValue() <= 0;
    }

    @Override
    public boolean isFriendly(ICombatEntity entity) {
        return this.getTeam() == entity.getTeam();
    }

    @Override
    public boolean isIndestructible() {
        return this.isIndestructible;
    }

    @Override
    public boolean isNeutral() {
        return this.getTeam() == 0;
    }

    @Override
    public void resurrect() {
        if (!this.isDead()) {
            return;
        }
        this.getHitPoints().modifyBaseValue(new AttributeModifier(Modification.SET, this.getHitPoints().getMaxValue().intValue()));
        for (CombatEntityListener listener : this.listeners) {
            listener.onResurrection(this);
        }
        this.setCollision(true);
    }

    @Override
    public void setIndestructible(boolean indestructible) {
        this.isIndestructible = indestructible;
    }

    @Override
    public void setTarget(ICombatEntity target) {
        this.target = target;
    }

    @Override
    public void setTeam(int team) {
        this.team = team;
    }

    @Override
    public boolean wasHit(int timeSpan) {
        return Game.loop().getDeltaTime(this.lastHit) < (long)timeSpan;
    }
}

