/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.configuration;

import de.gurkenlabs.litiengine.configuration.ConfigurationGroup;
import de.gurkenlabs.litiengine.configuration.ConfigurationGroupInfo;
import de.gurkenlabs.litiengine.configuration.Quality;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;

@ConfigurationGroupInfo(prefix="gfx_")
public class GraphicConfiguration
extends ConfigurationGroup {
    private boolean fullscreen = false;
    private Quality graphicQuality = Quality.LOW;
    private boolean renderDynamicShadows = false;
    private int resolutionHeight = 900;
    private int resolutionWidth = 1600;
    private boolean enableResolutionScale;
    private boolean reduceFramesWhenNotFocused;
    private boolean antiAliasing;
    private boolean colorInterpolation;

    public GraphicConfiguration() {
        this.setEnableResolutionScale(true);
        this.setReduceFramesWhenNotFocused(true);
        this.setAntiAliasing(false);
        this.setColorInterpolation(false);
    }

    public Quality getGraphicQuality() {
        return this.graphicQuality;
    }

    public Dimension getResolution() {
        if (this.isFullscreen()) {
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            int width = gd.getDisplayMode().getWidth();
            int height = gd.getDisplayMode().getHeight();
            return new Dimension(width, height);
        }
        return new Dimension(this.resolutionWidth, this.resolutionHeight);
    }

    public int getResolutionHeight() {
        return this.resolutionHeight;
    }

    public int getResolutionWidth() {
        return this.resolutionWidth;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public boolean renderDynamicShadows() {
        return this.renderDynamicShadows;
    }

    public boolean antiAlising() {
        return this.antiAliasing;
    }

    public boolean colorInterpolation() {
        return this.colorInterpolation;
    }

    public void setFullscreen(boolean fullscreen) {
        if (fullscreen == this.fullscreen) {
            return;
        }
        this.fullscreen = fullscreen;
    }

    public void setGraphicQuality(Quality graphicQuality) {
        this.graphicQuality = graphicQuality;
    }

    public void setRenderDynamicShadows(boolean renderDynamicShadows) {
        this.renderDynamicShadows = renderDynamicShadows;
    }

    public void setResolutionHeight(int resolutionHeight) {
        this.resolutionHeight = resolutionHeight;
    }

    public void setResolutionWidth(int resolutionWidth) {
        this.resolutionWidth = resolutionWidth;
    }

    public boolean enableResolutionScaling() {
        return this.enableResolutionScale;
    }

    public void setEnableResolutionScale(boolean enableResolutionScale) {
        this.enableResolutionScale = enableResolutionScale;
    }

    public boolean reduceFramesWhenNotFocused() {
        return this.reduceFramesWhenNotFocused;
    }

    public void setReduceFramesWhenNotFocused(boolean reduceFramesWhenNotFocused) {
        this.reduceFramesWhenNotFocused = reduceFramesWhenNotFocused;
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
    }

    public void setColorInterpolation(boolean colorInterpolation) {
        this.colorInterpolation = colorInterpolation;
    }
}

