/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.configuration;

import de.gurkenlabs.litiengine.configuration.ConfigurationGroupInfo;
import de.gurkenlabs.litiengine.util.ReflectionUtilities;
import java.lang.reflect.Field;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@ConfigurationGroupInfo
public abstract class ConfigurationGroup {
    private static final Logger log = Logger.getLogger(ConfigurationGroup.class.getName());
    private final String prefix;
    private boolean debug;

    public ConfigurationGroup() {
        ConfigurationGroupInfo info = this.getClass().getAnnotation(ConfigurationGroupInfo.class);
        this.prefix = info.prefix();
        this.debug = info.debug();
    }

    public String getPrefix() {
        return this.prefix != null ? this.prefix : "";
    }

    protected void initializeByProperty(String key, String value) {
        String propertyName = key.substring(this.getPrefix().length());
        ReflectionUtilities.setFieldValue(this.getClass(), this, propertyName, value);
    }

    protected void storeProperties(Properties properties) {
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                String propertyKey = this.getPrefix() + field.getName();
                if (field.getType().equals(Boolean.TYPE)) {
                    properties.setProperty(propertyKey, Boolean.toString(field.getBoolean(this)));
                    continue;
                }
                if (field.getType().equals(Integer.TYPE)) {
                    properties.setProperty(propertyKey, Integer.toString(field.getInt(this)));
                    continue;
                }
                if (field.getType().equals(Float.TYPE)) {
                    properties.setProperty(propertyKey, Float.toString(field.getFloat(this)));
                    continue;
                }
                if (field.getType().equals(Double.TYPE)) {
                    properties.setProperty(propertyKey, Double.toString(field.getDouble(this)));
                    continue;
                }
                if (field.getType().equals(Byte.TYPE)) {
                    properties.setProperty(propertyKey, Byte.toString(field.getByte(this)));
                    continue;
                }
                if (field.getType().equals(Short.TYPE)) {
                    properties.setProperty(propertyKey, Short.toString(field.getShort(this)));
                    continue;
                }
                if (field.getType().equals(Long.TYPE)) {
                    properties.setProperty(propertyKey, Long.toString(field.getLong(this)));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    properties.setProperty(propertyKey, field.get(this) != null ? (String)field.get(this) : "");
                    continue;
                }
                if (field.getType().equals(String[].class)) {
                    properties.setProperty(propertyKey, field.get(this) != null ? String.join((CharSequence)",", (String[])field.get(this)) : "");
                    continue;
                }
                if (!field.getType().isEnum()) continue;
                Object val = field.get(this);
                String value = val == null && field.getType().getEnumConstants().length > 0 ? field.getType().getEnumConstants()[0].toString() : "";
                properties.setProperty(propertyKey, val != null ? val.toString() : value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

