/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.attributes;

import de.gurkenlabs.litiengine.attributes.Attribute;
import de.gurkenlabs.litiengine.attributes.AttributeModifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RangeAttribute<T extends Number>
extends Attribute<T> {
    private final List<AttributeModifier<T>> maxModifiers = new ArrayList<AttributeModifier<T>>();
    private final T minBaseValue;
    private T maxBaseValue;

    public RangeAttribute(T maxValue, T minValue, T baseValue) {
        super(baseValue);
        this.maxBaseValue = maxValue;
        this.minBaseValue = minValue;
    }

    public void addMaxModifier(AttributeModifier<T> modifier) {
        if (this.getMaxModifiers().contains(modifier)) {
            return;
        }
        this.getMaxModifiers().add(modifier);
        Collections.sort(this.getMaxModifiers());
    }

    @Override
    public T getCurrentValue() {
        Object current = this.applyModifiers(this.getBaseValue());
        return this.valueInRange(current);
    }

    public T getMaxValue() {
        return this.applyMaxModifiers(this.maxBaseValue);
    }

    public float getRelativeCurrentValue() {
        return ((Number)this.getCurrentValue()).floatValue() / ((Number)this.getMaxValue()).floatValue();
    }

    @Override
    public void modifyBaseValue(AttributeModifier<T> modifier) {
        this.setBaseValue(this.valueInRange(modifier.modify(this.getBaseValue())));
    }

    public void modifyMaxBaseValue(AttributeModifier<T> modifier) {
        this.maxBaseValue = modifier.modify(this.maxBaseValue);
    }

    public void setToMaxValue() {
        this.setBaseValue(this.getMaxValue());
    }

    protected List<AttributeModifier<T>> getMaxModifiers() {
        return this.maxModifiers;
    }

    protected T applyMaxModifiers(T maxValue) {
        if (this.getMaxModifiers().isEmpty()) {
            return maxValue;
        }
        T currentValue = maxValue;
        for (AttributeModifier<T> modifier : this.getMaxModifiers()) {
            currentValue = modifier.modify(currentValue);
        }
        return currentValue;
    }

    private T valueInRange(T value) {
        if (((Number)value).doubleValue() < ((Number)this.minBaseValue).doubleValue()) {
            return this.minBaseValue;
        }
        if (((Number)value).doubleValue() > ((Number)this.getMaxValue()).doubleValue()) {
            return this.getMaxValue();
        }
        return value;
    }
}

