/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities.effects;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.abilities.Ability;
import de.gurkenlabs.litiengine.abilities.effects.Effect;
import de.gurkenlabs.litiengine.abilities.effects.EffectTarget;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.sound.Sound;
import java.util.Random;

public class SoundEffect
extends Effect {
    private final Sound[] sounds;

    public SoundEffect(Ability ability, Sound ... sounds) {
        super(ability, EffectTarget.EXECUTINGENTITY);
        this.sounds = sounds;
    }

    @Override
    protected void apply(ICombatEntity entity) {
        super.apply(entity);
        if (this.sounds.length == 0) {
            return;
        }
        Game.audio().playSound(entity, this.getRandomSound());
    }

    private Sound getRandomSound() {
        if (this.sounds.length == 0) {
            return null;
        }
        int randomIndex = new Random().nextInt(this.sounds.length);
        return this.sounds[randomIndex];
    }
}

