/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities.effects;

import de.gurkenlabs.litiengine.abilities.Ability;
import de.gurkenlabs.litiengine.abilities.effects.Effect;
import de.gurkenlabs.litiengine.abilities.effects.EffectApplication;
import de.gurkenlabs.litiengine.abilities.effects.EffectTarget;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.physics.Force;

public abstract class ForceEffect
extends Effect {
    private final float strength;
    private Force appliedForce;

    protected ForceEffect(Ability ability, float strength, EffectTarget ... targets) {
        super(ability, targets);
        this.strength = strength;
    }

    @Override
    public void apply(ICombatEntity affectedEntity) {
        super.apply(affectedEntity);
        if (this.getAppliedForce() != null) {
            return;
        }
        Force force = this.applyForce(affectedEntity);
        if (force != null) {
            this.appliedForce = force;
        }
    }

    public float getStrength() {
        return this.strength;
    }

    protected abstract Force applyForce(ICombatEntity var1);

    @Override
    protected void cease(EffectApplication appliance) {
        super.cease(appliance);
        if (this.getAppliedForce() != null) {
            this.getAppliedForce().end();
            this.appliedForce = null;
        }
    }

    protected Force getAppliedForce() {
        return this.appliedForce;
    }

    @Override
    protected boolean hasEnded(EffectApplication appliance) {
        return super.hasEnded(appliance) || this.getAppliedForce() == null;
    }
}

