/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities.effects;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.abilities.Ability;
import de.gurkenlabs.litiengine.abilities.effects.EffectApplication;
import de.gurkenlabs.litiengine.abilities.effects.EffectArgument;
import de.gurkenlabs.litiengine.abilities.effects.EffectTarget;
import de.gurkenlabs.litiengine.abilities.effects.IEffect;
import de.gurkenlabs.litiengine.entities.EntityComparator;
import de.gurkenlabs.litiengine.entities.EntityDistanceComparator;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class Effect
implements IEffect {
    public static final int NO_DURATION = -1;
    private final Ability ability;
    private final List<EffectApplication> appliances;
    private final List<Consumer<EffectArgument>> appliedConsumer = new CopyOnWriteArrayList<Consumer<EffectArgument>>();
    private final List<Consumer<EffectArgument>> ceasedConsumer = new CopyOnWriteArrayList<Consumer<EffectArgument>>();
    private final EffectTarget[] effectTargets;
    private final List<IEffect> followUpEffects;
    private int delay;
    private int duration;
    private EntityComparator targetPriorityComparator;

    protected Effect(Ability ability, EffectTarget ... targets) {
        this.appliances = new ArrayList<EffectApplication>();
        this.followUpEffects = new CopyOnWriteArrayList<IEffect>();
        this.ability = ability;
        this.targetPriorityComparator = new EntityDistanceComparator(this.getAbility().getExecutor());
        this.duration = ability.getAttributes().getDuration().getCurrentValue();
        this.effectTargets = targets == null || targets.length == 0 ? new EffectTarget[]{EffectTarget.NONE} : targets;
    }

    @Override
    public void apply(Shape impactArea) {
        List<ICombatEntity> affected = this.lookForAffectedEntities(impactArea);
        for (ICombatEntity affectedEntity : affected) {
            this.apply(affectedEntity);
        }
        this.appliances.add(new EffectApplication(affected, impactArea));
        if (this.appliances.size() == 1) {
            Game.loop().attach(this);
        }
    }

    @Override
    public void cease(ICombatEntity entity) {
        entity.getAppliedEffects().remove(this);
        EffectArgument arg = new EffectArgument(this, entity);
        for (Consumer<EffectArgument> consumer : this.ceasedConsumer) {
            consumer.accept(arg);
        }
    }

    public Ability getAbility() {
        return this.ability;
    }

    @Override
    public List<EffectApplication> getActiveAppliances() {
        return this.appliances;
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public EffectTarget[] getEffectTargets() {
        return this.effectTargets;
    }

    @Override
    public List<IEffect> getFollowUpEffects() {
        return this.followUpEffects;
    }

    public EntityComparator getTargetPriorityComparator() {
        return this.targetPriorityComparator;
    }

    @Override
    public boolean isActive(ICombatEntity entity) {
        for (EffectApplication app : this.getActiveAppliances()) {
            for (ICombatEntity affected : app.getAffectedEntities()) {
                if (!affected.equals(entity)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onEffectApplied(Consumer<EffectArgument> consumer) {
        if (!this.appliedConsumer.contains(consumer)) {
            this.appliedConsumer.add(consumer);
        }
    }

    @Override
    public void onEffectCeased(Consumer<EffectArgument> consumer) {
        if (!this.ceasedConsumer.contains(consumer)) {
            this.ceasedConsumer.add(consumer);
        }
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setTargetPriorityComparator(EntityComparator targetPriorityComparator) {
        this.targetPriorityComparator = targetPriorityComparator;
    }

    @Override
    public void update() {
        Iterator<EffectApplication> iterator = this.getActiveAppliances().iterator();
        while (iterator.hasNext()) {
            EffectApplication appliance = iterator.next();
            if (!this.hasEnded(appliance)) continue;
            iterator.remove();
            this.cease(appliance);
        }
        if (this.getActiveAppliances().isEmpty()) {
            Game.loop().detach(this);
        }
    }

    protected void apply(ICombatEntity entity) {
        entity.getAppliedEffects().add(this);
        EffectArgument arg = new EffectArgument(this, entity);
        for (Consumer<EffectArgument> consumer : this.appliedConsumer) {
            consumer.accept(arg);
        }
    }

    protected void cease(EffectApplication appliance) {
        for (ICombatEntity entity : appliance.getAffectedEntities()) {
            this.cease(entity);
        }
        this.getFollowUpEffects().forEach(followUp -> followUp.apply(appliance.getImpactArea()));
    }

    protected Collection<ICombatEntity> getEntitiesInImpactArea(Shape impactArea) {
        return Game.world().environment().findCombatEntities(impactArea);
    }

    protected long getTotalDuration() {
        return (long)this.getDuration() + (long)this.getDelay();
    }

    protected boolean hasEnded(EffectApplication appliance) {
        long effectDuration = Game.loop().getDeltaTime(appliance.getAppliedTicks());
        return effectDuration > (long)this.getDuration();
    }

    protected List<ICombatEntity> lookForAffectedEntities(Shape impactArea) {
        List<ICombatEntity> affectedEntities = new ArrayList<ICombatEntity>();
        block6: for (EffectTarget target : this.effectTargets) {
            switch (target) {
                case EXECUTINGENTITY: {
                    affectedEntities.add(this.getAbility().getExecutor());
                    return affectedEntities;
                }
                case ENEMY: {
                    affectedEntities.addAll(this.getEntitiesInImpactArea(impactArea));
                    affectedEntities = affectedEntities.stream().filter(this.canAttackEntity()).collect(Collectors.toList());
                    continue block6;
                }
                case FRIENDLY: {
                    affectedEntities.addAll(this.getEntitiesInImpactArea(impactArea));
                    affectedEntities = affectedEntities.stream().filter(this.isAliveFriendlyEntity()).collect(Collectors.toList());
                    continue block6;
                }
                case FRIENDLYDEAD: {
                    affectedEntities.addAll(this.getEntitiesInImpactArea(impactArea));
                    affectedEntities = affectedEntities.stream().filter(this.isDeadFriendlyEntity()).collect(Collectors.toList());
                    continue block6;
                }
            }
        }
        affectedEntities.removeAll(Collections.singleton(null));
        affectedEntities.sort(this.targetPriorityComparator);
        if (!this.getAbility().isMultiTarget() && !affectedEntities.isEmpty()) {
            ICombatEntity target = this.getAbility().getExecutor().getTarget() != null ? this.getAbility().getExecutor().getTarget() : (ICombatEntity)affectedEntities.get(0);
            affectedEntities = new ArrayList();
            affectedEntities.add(target);
        }
        return affectedEntities;
    }

    private Predicate<? super ICombatEntity> canAttackEntity() {
        return entity -> !entity.equals(this.getAbility().getExecutor()) && !entity.isFriendly(this.getAbility().getExecutor()) && !entity.isDead();
    }

    private Predicate<? super ICombatEntity> isAliveFriendlyEntity() {
        return entity -> !entity.equals(this.getAbility().getExecutor()) && entity.isFriendly(this.getAbility().getExecutor()) && !entity.isDead();
    }

    private Predicate<? super ICombatEntity> isDeadFriendlyEntity() {
        return entity -> !entity.equals(this.getAbility().getExecutor()) && entity.isFriendly(this.getAbility().getExecutor()) && entity.isDead();
    }
}

