/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.util.MathUtilities;

public enum Valign {
    DOWN,
    MIDDLE,
    TOP,
    MIDDLE_TOP,
    MIDDLE_DOWN;


    public static Valign get(String valign) {
        if (valign == null || valign.isEmpty()) {
            return DOWN;
        }
        try {
            return Valign.valueOf(valign.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return DOWN;
        }
    }

    public double getValue(double height) {
        switch (this) {
            case DOWN: {
                return height;
            }
            case MIDDLE: {
                return height / 2.0;
            }
            case MIDDLE_DOWN: {
                return height * 0.75;
            }
            case MIDDLE_TOP: {
                return height * 0.25;
            }
        }
        return 0.0;
    }

    public double getLocation(double height, double objectHeight) {
        double value = this.getValue(height);
        double location = value - objectHeight / 2.0;
        if (objectHeight > height) {
            return location;
        }
        return MathUtilities.clamp(location, 0.0, height - objectHeight);
    }
}

