/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.UpdateLoop;
import de.gurkenlabs.litiengine.util.TimeUtilities;

public class RenderLoop
extends UpdateLoop {
    private int maxFps = Game.config().client().getMaxFps();

    public RenderLoop(String name) {
        super(name);
    }

    @Override
    public void run() {
        while (!RenderLoop.interrupted()) {
            long fpsWait = (long)(1000.0 / (double)this.maxFps);
            long renderStart = System.nanoTime();
            try {
                Game.world().camera().updateFocus();
                this.update();
                Game.window().getRenderComponent().render();
                long renderTime = (long)TimeUtilities.nanoToMs(System.nanoTime() - renderStart);
                long wait = Math.max(0L, fpsWait - renderTime);
                if (wait == 0L) continue;
                RenderLoop.sleep(wait);
            }
            catch (InterruptedException e) {
                this.interrupt();
                break;
            }
        }
    }

    @Override
    public void terminate() {
        this.interrupt();
    }

    public int getMaxFps() {
        return this.maxFps;
    }

    public void setMaxFps(int maxFps) {
        this.maxFps = maxFps;
    }
}

