/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public final class GameMetrics
implements IUpdateable,
IRenderable {
    private static final int OFFSET_X = 5;
    private static final int OFFSET_Y = 12;
    private final List<Long> bytesReceived;
    private final List<Long> bytesSent = new CopyOnWriteArrayList<Long>();
    private final Runtime runtime;
    private long downStreamInBytes;
    private long lastNetworkTickTime;
    private int packagesReceived;
    private int packagesSent;
    private long ping;
    private long upStreamInBytes;
    private long framesPerSecond;
    private long updatesPerSecond;
    private float usedMemory;

    GameMetrics() {
        this.bytesReceived = new CopyOnWriteArrayList<Long>();
        this.runtime = Runtime.getRuntime();
    }

    public float getDownStreamInBytes() {
        return this.downStreamInBytes;
    }

    public long getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public int getPackagesReceived() {
        return this.packagesReceived;
    }

    public int getPackagesSent() {
        return this.packagesSent;
    }

    public long getPing() {
        return this.ping;
    }

    public long getUpdatesPerSecond() {
        return this.updatesPerSecond;
    }

    public float getUpStreamInBytes() {
        return this.upStreamInBytes;
    }

    public float getUsedMemory() {
        return this.usedMemory;
    }

    public void packageReceived(long size) {
        this.bytesReceived.add(size);
    }

    public void packageSent(long size) {
        this.bytesSent.add(size);
    }

    public void recordNetworkTraffic() {
        Game.loop().attach(this);
    }

    @Override
    public void render(Graphics2D g) {
        int currentOffsetY = 12;
        g.setColor(Color.RED);
        g.setFont(new Font("SansSerif", 0, 10));
        String memory = "memory: " + this.usedMemory + "MB";
        g.drawString(memory, 5, currentOffsetY);
        String pingText = "ping: " + this.getPing() + "ms";
        g.drawString(pingText, 5, currentOffsetY += 12);
        float upStream = (float)Math.round(Game.metrics().getUpStreamInBytes() / 1024.0f * 100.0f) * 0.01f;
        float downStream = (float)Math.round(Game.metrics().getDownStreamInBytes() / 1024.0f * 100.0f) * 0.01f;
        String in = "in: " + this.getPackagesReceived() + " - " + downStream + "kb/s";
        g.drawString(in, 5, currentOffsetY += 12);
        String out = "out: " + this.getPackagesSent() + " - " + upStream + "kb/s";
        g.drawString(out, 5, currentOffsetY += 12);
        String fpsString = "fps: " + this.getFramesPerSecond();
        g.drawString(fpsString, 5, currentOffsetY += 12);
        String upsString = "ups: " + this.getUpdatesPerSecond();
        g.drawString(upsString, 5, currentOffsetY += 12);
    }

    public void setFramesPerSecond(long currentFramesPerSecond) {
        this.framesPerSecond = currentFramesPerSecond;
    }

    public void setPing(long ping) {
        this.ping = ping;
    }

    public void setUpdatesPerSecond(long updatesPerSecond) {
        this.updatesPerSecond = updatesPerSecond;
    }

    @Override
    public void update() {
        this.usedMemory = (float)Math.round((float)(this.runtime.totalMemory() - this.runtime.freeMemory()) / 1048576.0f * 10.0f) * 0.1f;
        long currentMillis = System.currentTimeMillis();
        if (currentMillis - this.lastNetworkTickTime >= 1000L) {
            this.lastNetworkTickTime = currentMillis;
            if (!this.bytesSent.isEmpty()) {
                long sumUp;
                Optional sentOpt = this.bytesSent.parallelStream().reduce((n1, n2) -> n1 + n2);
                this.upStreamInBytes = sumUp = !this.bytesSent.isEmpty() && sentOpt.isPresent() ? (Long)sentOpt.get() : 0L;
                this.packagesSent = this.bytesSent.size();
                this.bytesSent.clear();
            }
            if (!this.bytesReceived.isEmpty()) {
                long sumDown;
                Optional receivedOpt = this.bytesReceived.parallelStream().reduce((n1, n2) -> n1 + n2);
                this.downStreamInBytes = sumDown = !this.bytesReceived.isEmpty() && receivedOpt.isPresent() ? (Long)receivedOpt.get() : 0L;
                this.packagesReceived = this.bytesReceived.size();
                this.bytesReceived.clear();
            }
        }
    }
}

