/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.SpritesheetInfo;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Blueprint;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Map;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Tileset;
import de.gurkenlabs.litiengine.graphics.emitters.xml.EmitterData;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import de.gurkenlabs.litiengine.util.io.XmlUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="litidata")
public class GameData
implements Serializable {
    private static final Logger log = Logger.getLogger(GameData.class.getName());
    public static final String FILE_EXTENSION = "litidata";
    public static final float CURRENT_VERSION = 1.0f;
    private static final long serialVersionUID = -2101786184799276518L;
    @XmlAttribute(name="version")
    private float version;
    @XmlElementWrapper(name="maps")
    @XmlElement(name="map")
    private List<Map> maps;
    @XmlElementWrapper(name="spriteSheets")
    @XmlElement(name="sprite")
    private List<SpritesheetInfo> spriteSheets = new ArrayList<SpritesheetInfo>();
    @XmlElementWrapper(name="tilesets")
    @XmlElement(name="tileset")
    private List<Tileset> tilesets;
    @XmlElementWrapper(name="emitters")
    @XmlElement(name="emitter")
    private List<EmitterData> emitters;
    @XmlElementWrapper(name="blueprints")
    @XmlElement(name="blueprint")
    private List<Blueprint> blueprints;

    public GameData() {
        this.maps = new ArrayList<Map>();
        this.tilesets = new ArrayList<Tileset>();
        this.emitters = new ArrayList<EmitterData>();
        this.blueprints = new ArrayList<Blueprint>();
    }

    public static GameData load(String file) {
        try {
            GameData gameFile = GameData.getGameFileFromFile(file);
            if (gameFile == null) {
                return null;
            }
            gameFile.getMaps().parallelStream().forEach(map -> {
                for (Tileset tileset : map.getRawTilesets()) {
                    tileset.load(gameFile.getTilesets());
                }
                map.updateTileTerrain();
            });
            return gameFile;
        }
        catch (IOException | JAXBException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    @XmlTransient
    public List<Map> getMaps() {
        return this.maps;
    }

    @XmlTransient
    public List<SpritesheetInfo> getSpriteSheets() {
        return this.spriteSheets;
    }

    @XmlTransient
    public List<Tileset> getTilesets() {
        return this.tilesets;
    }

    @XmlTransient
    public List<EmitterData> getEmitters() {
        return this.emitters;
    }

    @XmlTransient
    public List<Blueprint> getBluePrints() {
        return this.blueprints;
    }

    public String save(String fileName, boolean compress) {
        File newFile;
        String fileNameWithExtension = fileName;
        if (!fileNameWithExtension.endsWith(".litidata")) {
            fileNameWithExtension = fileNameWithExtension + ".litidata";
        }
        if ((newFile = new File(fileNameWithExtension)).exists()) {
            try {
                Files.delete(newFile.toPath().toAbsolutePath());
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        Collections.sort(this.getMaps());
        try (FileOutputStream fileOut = new FileOutputStream(newFile, false);){
            JAXBContext jaxbContext = XmlUtilities.getContext(GameData.class);
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", false);
            if (compress) {
                GZIPOutputStream stream = new GZIPOutputStream(fileOut);
                jaxbMarshaller.marshal((Object)this, stream);
                stream.flush();
                stream.close();
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                jaxbMarshaller.marshal((Object)this, out);
                out.flush();
                XmlUtilities.saveWithCustomIndentation(new ByteArrayInputStream(out.toByteArray()), fileOut, 1);
                out.close();
            }
        }
        catch (IOException | JAXBException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return newFile.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GameData getGameFileFromFile(String file) throws JAXBException, IOException {
        JAXBContext jaxbContext = XmlUtilities.getContext(GameData.class);
        Unmarshaller um = jaxbContext.createUnmarshaller();
        try (InputStream inputStream = FileUtilities.getGameResource(file);){
            GZIPInputStream zipStream = new GZIPInputStream(inputStream);
            GameData gameData = (GameData)um.unmarshal(zipStream);
            return gameData;
        }
        catch (ZipException e) {
            return XmlUtilities.readFromFile(GameData.class, file);
        }
    }

    void beforeMarshal(Marshaller m) {
        ArrayList<SpritesheetInfo> distinctList = new ArrayList<SpritesheetInfo>();
        for (SpritesheetInfo sprite : this.getSpriteSheets()) {
            if (distinctList.stream().anyMatch(x -> x.getName().equals(sprite.getName()) && x.getImage().equals(sprite.getImage()))) continue;
            distinctList.add(sprite);
        }
        this.spriteSheets = distinctList;
        ArrayList<Tileset> distinctTilesets = new ArrayList<Tileset>();
        for (Tileset tileset : this.getTilesets()) {
            if (distinctTilesets.stream().anyMatch(x -> x.getName().equals(tileset.getName()))) continue;
            distinctTilesets.add(tileset);
        }
        this.tilesets = distinctTilesets;
        if (this.version == 0.0f) {
            this.version = 1.0f;
        }
    }
}

