/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.DefaultUncaughtExceptionHandler;
import de.gurkenlabs.litiengine.GameInfo;
import de.gurkenlabs.litiengine.GameListener;
import de.gurkenlabs.litiengine.GameLoop;
import de.gurkenlabs.litiengine.GameMetrics;
import de.gurkenlabs.litiengine.GameTerminatedListener;
import de.gurkenlabs.litiengine.GameTime;
import de.gurkenlabs.litiengine.IGameLoop;
import de.gurkenlabs.litiengine.RenderLoop;
import de.gurkenlabs.litiengine.configuration.ConfigurationGroup;
import de.gurkenlabs.litiengine.configuration.GameConfiguration;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.GameWorld;
import de.gurkenlabs.litiengine.graphics.Camera;
import de.gurkenlabs.litiengine.graphics.DebugRenderer;
import de.gurkenlabs.litiengine.graphics.GameWindow;
import de.gurkenlabs.litiengine.graphics.RenderEngine;
import de.gurkenlabs.litiengine.gui.screens.IScreenManager;
import de.gurkenlabs.litiengine.gui.screens.ScreenManager;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.physics.PhysicsEngine;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.sound.ISoundEngine;
import de.gurkenlabs.litiengine.sound.SoundEngine;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import de.gurkenlabs.litiengine.util.io.XmlUtilities;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public final class Game {
    public static final int EXIT_GAME_CLOSED = 0;
    public static final int EXIT_GAME_CRASHED = -1;
    public static final String COMMADLINE_ARG_RELEASE = "-release";
    public static final String COMMADLINE_ARG_NOGUI = "-nogui";
    private static final Logger log = Logger.getLogger(Game.class.getName());
    private static final String LOGGING_CONFIG_FILE = "logging.properties";
    private static boolean debug = true;
    private static boolean noGUIMode = false;
    private static final List<GameListener> gameListeners = new CopyOnWriteArrayList<GameListener>();
    private static final List<GameTerminatedListener> gameTerminatedListeners = new CopyOnWriteArrayList<GameTerminatedListener>();
    private static final RenderEngine graphicsEngine = new RenderEngine();
    private static final SoundEngine soundEngine;
    private static final PhysicsEngine physicsEngine;
    private static final GameConfiguration configuration;
    private static final GameMetrics metrics;
    private static final GameTime gameTime;
    private static GameInfo gameInfo;
    private static GameLoop gameLoop;
    private static RenderLoop renderLoop;
    private static ScreenManager screenManager;
    private static GameWorld world;
    private static boolean hasStarted;
    private static boolean initialized;

    private Game() {
        throw new UnsupportedOperationException();
    }

    public static void addGameListener(GameListener listener) {
        gameListeners.add(listener);
        gameTerminatedListeners.add(listener);
    }

    public static void removeGameListener(GameListener listener) {
        gameListeners.remove(listener);
        gameTerminatedListeners.remove(listener);
    }

    public static void addGameTerminatedListener(GameTerminatedListener listener) {
        gameTerminatedListeners.add(listener);
    }

    public static void removeGameTerminatedListener(GameTerminatedListener listener) {
        gameTerminatedListeners.remove(listener);
    }

    public static void allowDebug(boolean allow) {
        debug = allow;
    }

    public static void hideGUI(boolean noGui) {
        noGUIMode = noGui;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static boolean isInNoGUIMode() {
        return noGUIMode;
    }

    public static GameInfo info() {
        return gameInfo;
    }

    public static GameConfiguration config() {
        return configuration;
    }

    public static GameMetrics metrics() {
        return metrics;
    }

    public static GameTime time() {
        return gameTime;
    }

    public static GameWindow window() {
        return screenManager;
    }

    public static ISoundEngine audio() {
        return soundEngine;
    }

    public static PhysicsEngine physics() {
        return physicsEngine;
    }

    public static RenderEngine graphics() {
        return graphicsEngine;
    }

    public static IGameLoop loop() {
        return gameLoop;
    }

    public static RenderLoop renderLoop() {
        return renderLoop;
    }

    public static IScreenManager screens() {
        return screenManager;
    }

    public static GameWorld world() {
        return world;
    }

    public static boolean hasStarted() {
        return hasStarted;
    }

    public static synchronized void init(String ... args) {
        if (initialized) {
            log.log(Level.INFO, "The game has already been initialized.");
            return;
        }
        Game.handleCommandLineArguments(args);
        Game.config().load();
        Locale.setDefault(new Locale(Game.config().client().getCountry(), Game.config().client().getLanguage()));
        gameLoop = new GameLoop("Main Update Loop", Game.config().client().getUpdaterate());
        gameLoop.attach(Game.physics());
        gameLoop.attach(Game.metrics());
        gameLoop.attach(Game.world());
        ScreenManager scrMgr = new ScreenManager(Game.info().getTitle());
        renderLoop = new RenderLoop("Render Loop");
        Game.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(Game.config().client().exitOnError()));
        screenManager = scrMgr;
        Game.window().init();
        world.setCamera(new Camera());
        if (new File(LOGGING_CONFIG_FILE).exists()) {
            System.setProperty("java.util.logging.config.file", LOGGING_CONFIG_FILE);
            try {
                LogManager.getLogManager().readConfiguration();
            }
            catch (Exception e2) {
                log.log(Level.SEVERE, e2.getMessage(), e2);
            }
        }
        for (GameListener listener : gameListeners) {
            listener.initialized(args);
        }
        if (!Game.isInNoGUIMode()) {
            if (Game.config().client().showGameMetrics()) {
                Game.window().getRenderComponent().onRendered(g -> Game.metrics().render((Graphics2D)g));
            }
            if (Game.config().debug().isDebugEnabled()) {
                Game.graphics().onEntityRendered(e -> DebugRenderer.renderEntityDebugInfo(e.getGraphics(), (IEntity)e.getRenderedObject()));
            }
            Game.window().getRenderComponent().onFpsChanged(fps -> Game.metrics().setFramesPerSecond(fps.intValue()));
            Game.window().setIconImage((Image)Resources.images().get("litiengine-icon.png"));
            Game.window().getRenderComponent().addMouseListener(Input.mouse());
            Game.window().getRenderComponent().addMouseMotionListener(Input.mouse());
            Game.window().getRenderComponent().addMouseWheelListener(Input.mouse());
            Input.keyboard().onKeyTyped(154, key -> Game.window().getRenderComponent().takeScreenshot());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(Game::terminate, "Shutdown"));
        initialized = true;
    }

    public static void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        gameLoop.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        renderLoop.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
    }

    public static synchronized void start() {
        if (!initialized) {
            throw new IllegalStateException("The game cannot be started without being first initialized. Call Game.init(...) before Game.start().");
        }
        gameLoop.start();
        soundEngine.start();
        if (!Game.isInNoGUIMode()) {
            renderLoop.start();
        }
        for (GameListener listener : gameListeners) {
            listener.started();
        }
        hasStarted = true;
    }

    public static synchronized void terminate() {
        for (GameListener gameListener : gameListeners) {
            if (gameListener.terminating()) continue;
            return;
        }
        hasStarted = false;
        initialized = false;
        Game.config().save();
        gameLoop.terminate();
        soundEngine.terminate();
        Game.world().clear();
        if (!Game.isInNoGUIMode()) {
            renderLoop.terminate();
        }
        for (GameTerminatedListener gameTerminatedListener : gameTerminatedListeners) {
            gameTerminatedListener.terminated();
        }
    }

    public static void setInfo(GameInfo info) {
        gameInfo = info;
    }

    public static void setInfo(String gameInfoFile) {
        GameInfo info;
        try {
            info = XmlUtilities.readFromFile(GameInfo.class, gameInfoFile);
        }
        catch (JAXBException e) {
            log.log(Level.WARNING, "Could not read game info from {0}", new Object[]{gameInfoFile});
            Game.setInfo((GameInfo)null);
            return;
        }
        Game.setInfo(info);
    }

    private static void handleCommandLineArguments(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        if (ArrayUtilities.containsArgument(args, COMMADLINE_ARG_RELEASE)) {
            Game.allowDebug(false);
        }
        if (ArrayUtilities.containsArgument(args, COMMADLINE_ARG_NOGUI)) {
            Game.hideGUI(true);
        }
    }

    static {
        physicsEngine = new PhysicsEngine();
        soundEngine = new SoundEngine();
        metrics = new GameMetrics();
        gameInfo = new GameInfo();
        gameTime = new GameTime();
        configuration = new GameConfiguration(new ConfigurationGroup[0]);
        world = new GameWorld();
        world.addLoadedListener(gameTime);
        Game.addGameListener(new Input.InputGameAdapter());
    }
}

