/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

public enum Direction {
    DOWN(1),
    LEFT(2),
    RIGHT(4),
    UNDEFINED(8),
    UP(16);

    private final byte flagValue;

    public static Direction fromAngle(double angle) {
        if (angle >= 0.0 && angle < 45.0) {
            return DOWN;
        }
        if (angle >= 45.0 && angle < 135.0) {
            return RIGHT;
        }
        if (angle >= 135.0 && angle < 225.0) {
            return UP;
        }
        if (angle >= 225.0 && angle < 315.0) {
            return LEFT;
        }
        if (angle >= 315.0 && angle <= 360.0) {
            return DOWN;
        }
        return UNDEFINED;
    }

    public static Direction fromFlagValue(byte flagValue) {
        for (Direction dir : Direction.values()) {
            if (dir.getFlagValue() != flagValue) continue;
            return dir;
        }
        return UNDEFINED;
    }

    public static float toAngle(Direction dir) {
        switch (dir) {
            case RIGHT: {
                return 90.0f;
            }
            case UP: {
                return 180.0f;
            }
            case LEFT: {
                return 270.0f;
            }
            case DOWN: {
                return 360.0f;
            }
        }
        return 0.0f;
    }

    public byte getFlagValue() {
        return this.flagValue;
    }

    private Direction(byte flagValue) {
        this.flagValue = flagValue;
    }

    public Direction getOpposite() {
        switch (this) {
            case RIGHT: {
                return LEFT;
            }
            case UP: {
                return DOWN;
            }
            case LEFT: {
                return RIGHT;
            }
            case DOWN: {
                return UP;
            }
        }
        return this;
    }

    public float toAngle() {
        return Direction.toAngle(this);
    }
}

