/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileUtilities {
    private static final Logger log = Logger.getLogger(FileUtilities.class.getName());
    private static final String[] DIR_BLACKLIST = new String[]{"\\bin", "\\screenshots"};
    private static final String FILE_SEPARATOR_WIN = "\\";
    private static final String FILE_SEPARATOR_LINUX = "/";

    private FileUtilities() {
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtilities.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        try {
            Files.delete(dir.toPath().toAbsolutePath());
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
        return true;
    }

    public static List<String> findFilesByExtension(List<String> fileNames, Path dir, String extension) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                if (path.toFile().isDirectory()) {
                    if (FileUtilities.isBlackListedDirectory(path)) continue;
                    FileUtilities.findFilesByExtension(fileNames, path, extension);
                    continue;
                }
                if (!path.toAbsolutePath().toString().endsWith(extension)) continue;
                fileNames.add(path.toAbsolutePath().toString());
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return fileNames;
    }

    public static List<String> findFiles(List<String> fileNames, Path dir, String ... files) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                if (path.toFile().isDirectory()) {
                    if (FileUtilities.isBlackListedDirectory(path)) continue;
                    FileUtilities.findFiles(fileNames, path, files);
                    continue;
                }
                for (String file : files) {
                    if (!path.toAbsolutePath().toString().endsWith(file)) continue;
                    fileNames.add(path.toAbsolutePath().toString());
                }
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return fileNames;
    }

    private static boolean isBlackListedDirectory(Path path) {
        for (String black : DIR_BLACKLIST) {
            if (!path.toAbsolutePath().toString().contains(black)) continue;
            return true;
        }
        return false;
    }

    public static String getExtension(File file) {
        return FileUtilities.getExtension(file.getAbsolutePath());
    }

    public static String getExtension(String path) {
        String fileName = FileUtilities.getFileName(path, true);
        if (!fileName.contains(".")) {
            return "";
        }
        try {
            return fileName.substring(fileName.lastIndexOf(46) + 1);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getFileName(String path) {
        return FileUtilities.getFileName(path, false);
    }

    public static String getFileName(String path, boolean extension) {
        int lastBackslash;
        int pos;
        if (path == null || path.isEmpty() || path.endsWith(FILE_SEPARATOR_WIN) || path.endsWith(FILE_SEPARATOR_LINUX)) {
            return "";
        }
        String name = path;
        if (!extension && (pos = name.lastIndexOf(46)) > 0) {
            name = name.substring(0, pos);
        }
        if ((lastBackslash = name.lastIndexOf(FILE_SEPARATOR_LINUX)) != -1) {
            name = name.substring(lastBackslash + 1, name.length());
        } else {
            int lastForwardSlash = name.lastIndexOf(FILE_SEPARATOR_WIN);
            if (lastForwardSlash != -1) {
                name = name.substring(lastForwardSlash + 1, name.length());
            }
        }
        return name;
    }

    public static InputStream getGameResource(String file) {
        InputStream stream = FileUtilities.findGameResource(file);
        return stream == null ? null : (stream.markSupported() ? stream : new BufferedInputStream(stream));
    }

    private static InputStream findGameResource(String file) {
        try {
            InputStream resourceStream = ClassLoader.getSystemResourceAsStream(file);
            if (resourceStream != null) {
                return resourceStream;
            }
            resourceStream = FileUtilities.class.getResourceAsStream(file);
            if (resourceStream != null) {
                return resourceStream;
            }
            File f = new File(file);
            if (f.exists()) {
                resourceStream = new FileInputStream(file);
                return resourceStream;
            }
            log.log(Level.INFO, "{0} could not be found.", file);
            return null;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static String getParentDirPath(String fileOrDirPath) {
        if (fileOrDirPath.contains(FILE_SEPARATOR_WIN)) {
            return fileOrDirPath.substring(0, fileOrDirPath.lastIndexOf(FILE_SEPARATOR_WIN) + 1);
        }
        if (fileOrDirPath.contains(FILE_SEPARATOR_LINUX)) {
            return fileOrDirPath.substring(0, fileOrDirPath.lastIndexOf(FILE_SEPARATOR_LINUX) + 1);
        }
        return "";
    }

    public static String combine(String basePath, String ... paths) {
        String combined = FileUtilities.ensurePathSeparator(new File(basePath).toPath().normalize().toString(), Character.toString(File.separatorChar));
        for (String path : paths) {
            if (path == null) continue;
            combined = FileUtilities.ensurePathSeparator(new File(combined).toPath().resolve(path).normalize().toString(), Character.toString(File.separatorChar));
        }
        return combined;
    }

    public static String ensurePathSeparator(String path, String separator) {
        String separatorToReplace = separator == FILE_SEPARATOR_LINUX ? FILE_SEPARATOR_WIN : FILE_SEPARATOR_LINUX;
        return path.replace(separatorToReplace, separator);
    }

    public static String removeTrailingSeparator(String path) {
        if (path.endsWith(FILE_SEPARATOR_WIN) || path.endsWith(FILE_SEPARATOR_LINUX)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String removeLeadingSeparator(String path) {
        if (path.startsWith(FILE_SEPARATOR_WIN) || path.startsWith(FILE_SEPARATOR_LINUX)) {
            return path.substring(1);
        }
        return path;
    }
}

