/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util.geom;

import de.gurkenlabs.litiengine.util.geom.PointDistanceComparator;
import de.gurkenlabs.litiengine.util.geom.Trigonometry;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GeometricUtilities {
    private static final double RAYCAST_EPSILON = 0.01;

    private GeometricUtilities() {
    }

    public static float calcRotationAngleInDegrees(double centerX, double centerY, double targetX, double targetY) {
        double theta = Trigonometry.atan2((float)(targetY - centerY), (float)(targetX - centerX));
        double angle = Math.toDegrees(theta);
        if ((angle -= 90.0) < 0.0) {
            angle += 360.0;
        }
        return (float)(360.0 - angle) % 360.0f;
    }

    public static float calcRotationAngleInDegrees(Point2D centerPt, Point2D targetPt) {
        return GeometricUtilities.calcRotationAngleInDegrees(centerPt.getX(), centerPt.getY(), targetPt.getX(), targetPt.getY());
    }

    public static boolean contains(Rectangle2D rectangle, Point2D p) {
        return rectangle.getX() <= p.getX() && rectangle.getY() <= p.getY() && rectangle.getX() + rectangle.getWidth() >= p.getX() && rectangle.getY() + rectangle.getHeight() >= p.getY();
    }

    public static double distance(double p1X, double p1Y, double p2X, double p2Y) {
        return Math.sqrt((p1X - p2X) * (p1X - p2X) + (p1Y - p2Y) * (p1Y - p2Y));
    }

    public static double distance(Point2D p1, Point2D p2) {
        return Math.sqrt((p1.getX() - p2.getX()) * (p1.getX() - p2.getX()) + (p1.getY() - p2.getY()) * (p1.getY() - p2.getY()));
    }

    public static double distance(Rectangle2D rect, Point2D p) {
        double dx = Math.max(rect.getMinX() - p.getX(), p.getX() - rect.getMaxX());
        double dy = Math.max(rect.getMinY() - p.getY(), p.getY() - rect.getMaxY());
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static boolean equals(Point2D point1, Point2D point2, double epsilon) {
        return point1.distance(point2) < epsilon;
    }

    public static Line2D[] getConnectingLines(Point2D point, Point2D[] rectPoints) {
        Line2D[] lines = new Line2D[rectPoints.length];
        for (int i = 0; i < rectPoints.length; ++i) {
            lines[i] = new Line2D.Double(point.getX(), point.getY(), rectPoints[i].getX(), rectPoints[i].getY());
        }
        return lines;
    }

    public static List<Line2D.Double> getConstrainingLines(Area area) {
        ArrayList<double[]> areaPoints = new ArrayList<double[]>();
        ArrayList<Line2D.Double> areaSegments = new ArrayList<Line2D.Double>();
        double[] coords = new double[6];
        PathIterator pi = area.getPathIterator(null);
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            double[] pathIteratorCoords = new double[]{type, coords[0], coords[1]};
            areaPoints.add(pathIteratorCoords);
            pi.next();
        }
        double[] start = new double[3];
        for (int i = 0; i < areaPoints.size(); ++i) {
            double[] currentElement = (double[])areaPoints.get(i);
            double[] nextElement = new double[]{-1.0, -1.0, -1.0};
            if (i < areaPoints.size() - 1) {
                nextElement = (double[])areaPoints.get(i + 1);
            }
            if (currentElement[0] == 0.0) {
                start = currentElement;
            }
            if (nextElement[0] == 1.0) {
                areaSegments.add(new Line2D.Double(currentElement[1], currentElement[2], nextElement[1], nextElement[2]));
                continue;
            }
            if (nextElement[0] != 4.0) continue;
            areaSegments.add(new Line2D.Double(currentElement[1], currentElement[2], start[1], start[2]));
        }
        return areaSegments;
    }

    public static float getDeltaX(double angle) {
        double actualAngle = angle - 90.0;
        if (angle < 0.0) {
            actualAngle += 360.0;
        }
        actualAngle = 360.0 - actualAngle;
        return Trigonometry.cosDeg((float)actualAngle);
    }

    public static float getDeltaY(double angle) {
        double actualAngle = angle - 90.0;
        if (angle < 0.0) {
            actualAngle += 360.0;
        }
        actualAngle = 360.0 - actualAngle;
        return Trigonometry.sinDeg((float)actualAngle);
    }

    public static Point2D getIntersectionPoint(Line2D lineA, Line2D lineB) {
        double x1 = lineA.getX1();
        double y1 = lineA.getY1();
        double x2 = lineA.getX2();
        double y2 = lineA.getY2();
        double x3 = lineB.getX1();
        double y3 = lineB.getY1();
        double x4 = lineB.getX2();
        double y4 = lineB.getY2();
        Point2D.Double p = null;
        double d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (d != 0.0) {
            double xi = ((x3 - x4) * (x1 * y2 - y1 * x2) - (x1 - x2) * (x3 * y4 - y3 * x4)) / d;
            double yi = ((y3 - y4) * (x1 * y2 - y1 * x2) - (y1 - y2) * (x3 * y4 - y3 * x4)) / d;
            if (xi >= Math.min(lineA.getX1(), lineA.getX2()) && xi <= Math.max(lineA.getX1(), lineA.getX2()) && yi >= Math.min(lineA.getY1(), lineA.getY2()) && yi <= Math.max(lineA.getY1(), lineA.getY2())) {
                p = new Point2D.Double(xi, yi);
            }
        }
        return p;
    }

    public static Point2D getIntersectionPoint(Line2D line, Rectangle2D rectangle) {
        List<Point2D> intersectionPoints = GeometricUtilities.getIntersectionPoints(line, rectangle);
        for (Point2D p : intersectionPoints) {
            if (p == null || p.equals(line.getP1()) || !GeometricUtilities.contains(rectangle, p)) continue;
            return p;
        }
        return null;
    }

    public static List<Point2D> getIntersectionPoints(Line2D line, Rectangle2D rectangle) {
        Point2D p4;
        Point2D p3;
        Point2D p2;
        ArrayList<Point2D> intersectionPoints = new ArrayList<Point2D>();
        Line2D[] lines = GeometricUtilities.getLines(rectangle);
        Line2D topLine = lines[0];
        Line2D bottomLine = lines[1];
        Line2D leftLine = lines[2];
        Line2D rightLine = lines[3];
        Point2D p1 = GeometricUtilities.getIntersectionPoint(line, topLine);
        if (p1 != null && GeometricUtilities.contains(rectangle, p1)) {
            intersectionPoints.add(p1);
        }
        if ((p2 = GeometricUtilities.getIntersectionPoint(line, bottomLine)) != null && GeometricUtilities.contains(rectangle, p2) && !intersectionPoints.contains(p2)) {
            intersectionPoints.add(p2);
        }
        if ((p3 = GeometricUtilities.getIntersectionPoint(line, leftLine)) != null && !p3.equals(p1) && !p3.equals(p2) && GeometricUtilities.contains(rectangle, p3) && !intersectionPoints.contains(p3)) {
            intersectionPoints.add(p3);
        }
        if ((p4 = GeometricUtilities.getIntersectionPoint(line, rightLine)) != null && !p4.equals(p1) && !p4.equals(p2) && GeometricUtilities.contains(rectangle, p4) && !intersectionPoints.contains(p4)) {
            intersectionPoints.add(p4);
        }
        intersectionPoints.removeAll(Collections.singleton(null));
        return intersectionPoints;
    }

    public static Line2D[] getLines(Rectangle2D rectangle) {
        Line2D[] lines = new Line2D[]{new Line2D.Double(rectangle.getMinX(), rectangle.getMinY(), rectangle.getMinX(), rectangle.getMaxY()), new Line2D.Double(rectangle.getMinX(), rectangle.getMaxY(), rectangle.getMaxX(), rectangle.getMaxY()), new Line2D.Double(rectangle.getMaxX(), rectangle.getMaxY(), rectangle.getMaxX(), rectangle.getMinY()), new Line2D.Double(rectangle.getMaxX(), rectangle.getMinY(), rectangle.getMinX(), rectangle.getMinY())};
        return lines;
    }

    public static Point2D getMidPoint(Point2D p1, Point2D p2) {
        Point2D.Double mid = new Point2D.Double();
        double x = (p1.getX() + p2.getX()) / 2.0;
        double y = (p1.getY() + p2.getY()) / 2.0;
        ((Point2D)mid).setLocation(x, y);
        return mid;
    }

    public static Point2D getPerpendicularIntersection(Point2D point, Line2D line) {
        double x1 = line.getX1();
        double y1 = line.getY1();
        double x2 = line.getX2();
        double y2 = line.getY2();
        double x3 = point.getX();
        double y3 = point.getY();
        double k = ((y2 - y1) * (x3 - x1) - (x2 - x1) * (y3 - y1)) / (Math.pow(y2 - y1, 2.0) + Math.pow(x2 - x1, 2.0));
        double x4 = x3 - k * (y2 - y1);
        double y4 = y3 + k * (x2 - x1);
        return new Point2D.Double(x4, y4);
    }

    public static Point2D getPointOnCircle(Point2D center, double radius, double angle) {
        double x = center.getX() + radius * Math.cos(Math.toRadians(angle));
        double y = center.getY() + radius * Math.sin(Math.toRadians(angle));
        return new Point2D.Double(x, y);
    }

    public static List<Point2D> getPoints(Path2D path) {
        PathIterator pi = path.getPathIterator(null);
        double[] coordinates = new double[22];
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        while (!pi.isDone()) {
            pi.next();
            pi.currentSegment(coordinates);
            Point2D.Double currentPoint = new Point2D.Double(coordinates[0], coordinates[1]);
            points.add(currentPoint);
        }
        return points;
    }

    public static List<Point2D> getPoints(Rectangle2D rectangle) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(new Point2D.Double(rectangle.getMinX(), rectangle.getMinY()));
        points.add(new Point2D.Double(rectangle.getMaxX(), rectangle.getMinY()));
        points.add(new Point2D.Double(rectangle.getMaxX(), rectangle.getMaxY()));
        points.add(new Point2D.Double(rectangle.getMinX(), rectangle.getMaxY()));
        return points;
    }

    public static List<Point2D> getPointsBetweenPoints(Point2D point1, Point2D point2) {
        double x0 = point1.getX();
        double y0 = point1.getY();
        double x1 = point2.getX();
        double y1 = point2.getY();
        ArrayList<Point2D> line = new ArrayList<Point2D>();
        int dx = (int)Math.abs(x1 - x0);
        int dy = (int)Math.abs(y1 - y0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            line.add(new Point2D.Double(x0, y0));
            if (Math.abs(x0 - x1) < 1.0 && Math.abs(y0 - y1) < 1.0) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x0 += (double)sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y0 += (double)sy;
        }
        return line;
    }

    public static Point2D getRandomLocation(double x, double y, double width, double height) {
        double xOffset = Math.random() * width;
        double yOffset = Math.random() * height;
        return new Point2D.Double(x + xOffset, y + yOffset);
    }

    public static Point2D getRandomLocation(Rectangle2D rect) {
        return GeometricUtilities.getRandomLocation(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public static boolean intersects(Rectangle2D a, Rectangle2D b) {
        return Math.abs(a.getCenterX() - b.getCenterX()) < a.getWidth() * 0.5 + b.getWidth() * 0.5 && Math.abs(a.getCenterY() - b.getCenterY()) < a.getHeight() * 0.5 + b.getHeight() * 0.5;
    }

    public static Point2D project(Point2D start, double angle, double delta) {
        double x = start.getX();
        double y = start.getY();
        double xDelta = GeometricUtilities.getXDelta(angle, delta);
        double yDelta = GeometricUtilities.getYDelta(angle, delta);
        return new Point2D.Double(x += xDelta, y += yDelta);
    }

    public static Point2D project(Point2D start, Point2D end, double scalar) {
        double dx = end.getX() - start.getX();
        double dy = end.getY() - start.getY();
        double len = Math.hypot(dx, dy);
        return new Point2D.Double(start.getX() + dx * scalar / len, start.getY() + dy * scalar / len);
    }

    public static Point2D[] rayCastPoints(Point2D point, Rectangle2D rectangle) {
        List<Point2D> rectPoints = GeometricUtilities.getPoints(rectangle);
        rectPoints.sort(new PointDistanceComparator(point));
        Line2D[] connectingLines = GeometricUtilities.getConnectingLines(point, rectPoints.toArray(new Point2D[rectPoints.size()]));
        ArrayList<Point2D> resultPoints = new ArrayList<Point2D>();
        for (int i = 0; i < rectPoints.size(); ++i) {
            List<Point2D> intersectionPoints = GeometricUtilities.getIntersectionPoints(connectingLines[i], rectangle);
            if (intersectionPoints.stream().anyMatch(intersectionPoint -> rectPoints.stream().noneMatch(rectPoint -> GeometricUtilities.equals(rectPoint, intersectionPoint, 0.01)))) continue;
            resultPoints.add(rectPoints.get(i));
        }
        resultPoints.removeAll(Collections.singleton(null));
        return resultPoints.toArray(new Point2D[resultPoints.size()]);
    }

    public static Shape scaleRect(Rectangle2D shape, int max) {
        Dimension2D newDimension = GeometricUtilities.scaleWithRatio(shape.getWidth(), shape.getHeight(), max);
        if (newDimension == null) {
            return shape;
        }
        AffineTransform transform = AffineTransform.getScaleInstance(newDimension.getWidth(), newDimension.getHeight());
        return transform.createTransformedShape(shape);
    }

    public static Dimension2D scaleWithRatio(double width, double height, int max) {
        if (width == 0.0 || height == 0.0) {
            return null;
        }
        double dWidth = 0.0;
        double dHeight = 0.0;
        double ratio = width / height;
        double newWidth = height * ratio;
        double newHeight = width / ratio;
        if (newWidth == newHeight) {
            dWidth = max;
            dHeight = max;
        } else if (newWidth > newHeight) {
            dWidth = max;
            dHeight = height / width * (double)max;
        } else {
            dHeight = max;
            dWidth = width / height * (double)max;
        }
        Dimension dim = new Dimension();
        ((Dimension2D)dim).setSize(dWidth, dHeight);
        return dim;
    }

    public static Shape scaleShape(Shape shape, double scale) {
        AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
        return transform.createTransformedShape(shape);
    }

    public static boolean shapeIntersects(Shape shapeA, Shape shapeB) {
        if (!shapeA.getBounds2D().intersects(shapeB.getBounds2D())) {
            return false;
        }
        if (shapeA instanceof Rectangle2D && shapeB instanceof Rectangle2D) {
            return ((Rectangle2D)shapeA).intersects((Rectangle2D)shapeB);
        }
        Area areaA = new Area(shapeA);
        areaA.intersect(new Area(shapeB));
        return !areaA.isEmpty();
    }

    public static Shape translateShape(Shape shape, Point2D renderLocation) {
        AffineTransform t = new AffineTransform();
        t.translate(renderLocation.getX(), renderLocation.getY());
        return shape;
    }

    private static double getXDelta(double angle, double delta) {
        return (double)Trigonometry.sin((float)Math.toRadians(angle)) * delta * 100.0 / 100.0;
    }

    private static double getYDelta(double angle, double delta) {
        return (double)Trigonometry.cos((float)Math.toRadians(angle)) * delta * 100.0 / 100.0;
    }
}

