/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.sound;

import de.gurkenlabs.litiengine.Game;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sound.sampled.SourceDataLine;

final class SourceCloseQueue
implements Runnable {
    private final Queue<SourceDataLine> queue = new ConcurrentLinkedQueue<SourceDataLine>();
    private volatile boolean isRunning = true;

    SourceCloseQueue() {
    }

    void enqueue(SourceDataLine clip) {
        this.queue.add(clip);
    }

    @Override
    public void run() {
        while (this.isRunning) {
            this.closeAllSoundSources();
            try {
                Thread.sleep(1000 / Game.getConfiguration().client().getUpdaterate());
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        this.closeAllSoundSources();
    }

    void terminate() {
        this.isRunning = false;
    }

    private void closeAllSoundSources() {
        if (this.queue.isEmpty()) {
            return;
        }
        while (this.queue.peek() != null) {
            SourceDataLine clip = this.queue.poll();
            clip.stop();
            clip.flush();
            clip.close();
        }
    }
}

