/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.sound;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.sound.ISoundPlayback;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.sound.SoundEvent;
import de.gurkenlabs.litiengine.sound.SoundPlaybackListener;
import de.gurkenlabs.litiengine.sound.SourceCloseQueue;
import de.gurkenlabs.litiengine.util.MathUtilities;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

final class SoundPlayback
implements Runnable,
ISoundPlayback {
    private static final Logger log = Logger.getLogger(SoundPlayback.class.getName());
    private static final ExecutorService executorServie;
    private static final SourceCloseQueue closeQueue;
    private final List<SoundPlaybackListener> playbackListeners = new CopyOnWriteArrayList<SoundPlaybackListener>();
    private final Point2D initialListenerLocation;
    private SourceDataLine dataLine;
    private IEntity entity;
    private float gain;
    private float actualGain;
    private FloatControl gainControl;
    private FloatControl panControl;
    private Point2D location;
    private final Sound sound;
    private boolean playing;
    private boolean loop;
    private boolean cancelled;
    private boolean paused;

    SoundPlayback(Sound sound) {
        this(sound, null);
    }

    SoundPlayback(Sound sound, Point2D listenerLocation) {
        this.sound = sound;
        this.initialListenerLocation = listenerLocation;
        this.gain = 1.0f;
    }

    SoundPlayback(Sound sound, Point2D listenerLocation, IEntity sourceEntity) {
        this(sound, listenerLocation);
        this.entity = sourceEntity;
    }

    SoundPlayback(Sound sound, Point2D listenerLocation, Point2D location) {
        this(sound, listenerLocation);
        this.location = location;
    }

    @Override
    public void run() {
        this.playing = true;
        this.loadDataLine();
        if (this.dataLine == null) {
            return;
        }
        this.startDataLine();
        byte[] buffer = new byte[64];
        ByteArrayInputStream str = new ByteArrayInputStream(this.sound.getStreamData());
        while (!this.cancelled) {
            while (this.isPaused() && this.isPlaying() && !this.cancelled) {
                try {
                    Thread.sleep(1000 / Game.getConfiguration().client().getUpdaterate());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                int readCount = str.read(buffer);
                if (readCount < 0) {
                    if (!this.loop || this.dataLine == null) break;
                    this.restartDataLine();
                    str = new ByteArrayInputStream(this.sound.getStreamData());
                    continue;
                }
                if (this.dataLine == null) continue;
                this.dataLine.write(buffer, 0, readCount);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.dataLine != null) {
            this.dataLine.drain();
        }
        this.playing = false;
        SoundEvent event = new SoundEvent(this, this.sound);
        for (SoundPlaybackListener listener : this.playbackListeners) {
            listener.finished(event);
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        SoundEvent event = new SoundEvent(this, this.sound);
        for (SoundPlaybackListener listener : this.playbackListeners) {
            listener.cancelled(event);
        }
    }

    @Override
    public void addSoundPlaybackListener(SoundPlaybackListener soundPlaybackListener) {
        this.playbackListeners.add(soundPlaybackListener);
    }

    @Override
    public void removeSoundPlaybackListener(SoundPlaybackListener soundPlaybackListener) {
        this.playbackListeners.remove(soundPlaybackListener);
    }

    @Override
    public float getGain() {
        return this.gain;
    }

    @Override
    public void pausePlayback() {
        this.paused = true;
    }

    @Override
    public void resumePlayback() {
        this.paused = false;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public void setGain(float gain) {
        this.gain = MathUtilities.clamp(gain, 0.0f, 1.0f);
    }

    protected static void terminate() {
        closeQueue.terminate();
    }

    void dispose() {
        if (this.isPlaying()) {
            this.cancel();
        }
        if (this.dataLine != null) {
            closeQueue.enqueue(this.dataLine);
            this.dataLine = null;
            this.gainControl = null;
            this.panControl = null;
        }
    }

    Sound getSound() {
        return this.sound;
    }

    void play() {
        this.play(false, null, -1.0f);
    }

    void play(boolean loop, float volume) {
        this.play(loop, null, volume);
    }

    void play(boolean loop, Point2D location, float gain) {
        if (this.dataLine != null) {
            return;
        }
        this.actualGain = gain;
        this.location = location;
        this.loop = loop;
        executorServie.execute(this);
    }

    void setMasterGain(float g) {
        if (this.gainControl == null) {
            return;
        }
        float newGain = MathUtilities.clamp(g * this.gain, 0.0f, 1.0f);
        double minimumDB = this.gainControl.getMinimum();
        double maximumDB = 1.0;
        double ampGainDB = 0.5 - minimumDB;
        double cste = Math.log(10.0) / 20.0;
        float valueDB = (float)(minimumDB + 1.0 / cste * Math.log(1.0 + (Math.exp(cste * ampGainDB) - 1.0) * (double)newGain));
        this.gainControl.setValue(valueDB);
    }

    void updateControls(Point2D listenerLocation) {
        Point2D loc;
        if (listenerLocation == null) {
            return;
        }
        Point2D point2D = loc = this.entity != null ? this.entity.getCenter() : this.location;
        if (loc == null) {
            return;
        }
        this.setMasterGain(SoundPlayback.calculateGain(loc, listenerLocation));
        this.setPan(SoundPlayback.calculatePan(loc, listenerLocation));
    }

    private static float calculateGain(Point2D currentLocation, Point2D listenerLocation) {
        if (currentLocation == null || listenerLocation == null) {
            return 0.0f;
        }
        float distanceFromListener = (float)currentLocation.distance(listenerLocation);
        float gain = distanceFromListener <= 0.0f ? 1.0f : (distanceFromListener >= Game.getSoundEngine().getMaxDistance() ? 0.0f : 1.0f - distanceFromListener / Game.getSoundEngine().getMaxDistance());
        gain = MathUtilities.clamp(gain, 0.0f, 1.0f);
        return gain *= Game.getConfiguration().sound().getSoundVolume();
    }

    private static float calculatePan(Point2D currentLocation, Point2D listenerLocation) {
        double angle = GeometricUtilities.calcRotationAngleInDegrees(listenerLocation, currentLocation);
        return (float)(-Math.sin(angle));
    }

    private void initGain() {
        float initialGain = this.actualGain > 0.0f ? this.actualGain : Game.getConfiguration().sound().getSoundVolume();
        this.setMasterGain(initialGain);
    }

    private void loadDataLine() {
        DataLine.Info dataInfo = new DataLine.Info(SourceDataLine.class, this.sound.getFormat());
        try {
            this.dataLine = (SourceDataLine)AudioSystem.getLine(dataInfo);
            if (!this.dataLine.isOpen()) {
                this.dataLine.open();
            }
        }
        catch (LineUnavailableException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void startDataLine() {
        this.initControls();
        this.updateControls(this.initialListenerLocation);
        this.dataLine.start();
    }

    private void restartDataLine() {
        this.dataLine.drain();
        this.loadDataLine();
        this.initControls();
        this.dataLine.start();
    }

    private void initControls() {
        if (this.dataLine == null) {
            return;
        }
        try {
            this.panControl = !this.dataLine.isControlSupported(FloatControl.Type.PAN) ? null : (FloatControl)this.dataLine.getControl(FloatControl.Type.PAN);
        }
        catch (IllegalArgumentException iae) {
            this.panControl = null;
        }
        try {
            this.gainControl = !this.dataLine.isControlSupported(FloatControl.Type.MASTER_GAIN) ? null : (FloatControl)this.dataLine.getControl(FloatControl.Type.MASTER_GAIN);
        }
        catch (IllegalArgumentException iae) {
            this.gainControl = null;
        }
        this.initGain();
    }

    private void setPan(float p) {
        if (this.panControl == null) {
            return;
        }
        float pan = MathUtilities.clamp(p, -1.0f, 1.0f);
        this.panControl.setValue(pan);
    }

    static {
        closeQueue = new SourceCloseQueue();
        executorServie = Executors.newCachedThreadPool();
        executorServie.execute(closeQueue);
    }
}

