/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.physics;

import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.entities.Prop;
import de.gurkenlabs.litiengine.physics.CollisionType;
import de.gurkenlabs.litiengine.physics.IPhysicsEngine;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public final class PhysicsEngine
implements IPhysicsEngine {
    private final List<ICollisionEntity> collisionEntities;
    private Rectangle2D environmentBounds;
    private final List<Rectangle2D> staticCollisionBoxes;
    private final List<CollisionBox> entityCollisionBoxes = new CopyOnWriteArrayList<CollisionBox>();
    private final List<CollisionBox> allCollisionBoxes;
    private final List<CollisionBox> staticBoxes;
    private final List<Rectangle2D> allCollisionBoxRectangles;
    private final List<Rectangle2D> entityCollisionBoxesRectangles;

    public PhysicsEngine() {
        this.collisionEntities = new CopyOnWriteArrayList<ICollisionEntity>();
        this.staticCollisionBoxes = new CopyOnWriteArrayList<Rectangle2D>();
        this.allCollisionBoxes = new CopyOnWriteArrayList<CollisionBox>();
        this.staticBoxes = new CopyOnWriteArrayList<CollisionBox>();
        this.allCollisionBoxRectangles = new CopyOnWriteArrayList<Rectangle2D>();
        this.entityCollisionBoxesRectangles = new CopyOnWriteArrayList<Rectangle2D>();
    }

    @Override
    public void add(ICollisionEntity entity) {
        Prop prop;
        if (entity instanceof Prop && (prop = (Prop)entity).isObstacle()) {
            this.add(prop.getCollisionBox());
            return;
        }
        if (!this.collisionEntities.contains(entity)) {
            this.collisionEntities.add(entity);
        }
    }

    @Override
    public void add(Rectangle2D staticCollisionBox) {
        if (!this.staticCollisionBoxes.contains(staticCollisionBox)) {
            this.staticCollisionBoxes.add(staticCollisionBox);
        }
    }

    @Override
    public void clear() {
        this.staticCollisionBoxes.clear();
        this.collisionEntities.clear();
    }

    @Override
    public boolean collides(double x, double y) {
        return this.collides(new Point2D.Double(x, y));
    }

    @Override
    public boolean collides(double x, double y, CollisionType collisionType) {
        return this.collides((Point2D)new Point2D.Double(x, y), collisionType);
    }

    @Override
    public boolean collides(double x, double y, ICollisionEntity collisionEntity) {
        return this.collides((Point2D)new Point2D.Double(x, y), collisionEntity);
    }

    @Override
    public boolean collides(Point2D point, ICollisionEntity collisionEntity) {
        return this.collidesWithAnyEntity(collisionEntity, point) || this.collidesWithAnyStaticCollisionBox(point);
    }

    @Override
    public boolean collides(Point2D point, CollisionType collisionType) {
        switch (collisionType) {
            case ALL: {
                return this.collides(point);
            }
            case ENTITY: {
                return this.collidesWithAnyEntity(null, point);
            }
            case STATIC: {
                return this.collidesWithAnyStaticCollisionBox(point);
            }
        }
        return false;
    }

    @Override
    public Point2D collides(Line2D rayCast, CollisionType collisionType) {
        Point2D.Double rayCastSource = new Point2D.Double(rayCast.getX1(), rayCast.getY1());
        List<Rectangle2D> collBoxes = this.getAllCollisionBoxRectangles(collisionType);
        for (Rectangle2D collisionBox : collBoxes) {
            if (!collisionBox.intersectsLine(rayCast)) continue;
            double closestDist = -1.0;
            Point2D closestPoint = null;
            for (Point2D intersection : GeometricUtilities.getIntersectionPoints(rayCast, collisionBox)) {
                double dist = intersection.distance(rayCastSource);
                if (closestPoint != null && !(dist < closestDist)) continue;
                closestPoint = intersection;
                closestDist = dist;
            }
            return closestPoint;
        }
        return null;
    }

    @Override
    public Point2D collides(Line2D rayCast) {
        return this.collides(rayCast, CollisionType.ALL);
    }

    @Override
    public boolean collides(Point2D point) {
        if (this.environmentBounds != null && !this.environmentBounds.contains(point)) {
            return true;
        }
        for (Rectangle2D collisionBox : this.getAllCollisionBoxes()) {
            if (!collisionBox.contains(point)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean collides(Rectangle2D rect) {
        for (Rectangle2D collisionBox : this.getAllCollisionBoxes()) {
            if (!GeometricUtilities.intersects(rect, collisionBox)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean collides(Rectangle2D rect, CollisionType collisionType) {
        switch (collisionType) {
            case ALL: {
                return this.collides(rect);
            }
            case ENTITY: {
                return this.collidesWithAnyEntity(null, rect) != null;
            }
            case STATIC: {
                return this.collidesWithAnyStaticCollisionBox(rect) != null;
            }
        }
        return false;
    }

    @Override
    public List<ICollisionEntity> collidesWithEntities(Rectangle2D rect) {
        CopyOnWriteArrayList<ICollisionEntity> collEntities = new CopyOnWriteArrayList<ICollisionEntity>();
        for (ICollisionEntity coll : this.getCollisionEntities()) {
            if (!coll.getCollisionBox().intersects(rect)) continue;
            collEntities.add(coll);
        }
        return collEntities;
    }

    @Override
    public List<Rectangle2D> getAllCollisionBoxes() {
        return this.getAllCollisionBoxRectangles();
    }

    @Override
    public List<ICollisionEntity> getCollisionEntities() {
        return this.collisionEntities;
    }

    @Override
    public List<Rectangle2D> getStaticCollisionBoxes() {
        return this.staticCollisionBoxes;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.environmentBounds;
    }

    @Override
    public boolean move(IMobileEntity entity, double angle, double delta) {
        Point2D newPosition = GeometricUtilities.project(entity.getLocation(), angle, delta);
        return this.move(entity, newPosition);
    }

    @Override
    public boolean move(IMobileEntity entity, double x, double y, float delta) {
        return this.move(entity, new Point2D.Double(x, y), delta);
    }

    @Override
    public boolean move(IMobileEntity entity, float delta) {
        return this.move(entity, entity.getAngle(), (double)delta);
    }

    @Override
    public boolean move(IMobileEntity entity, Point2D newPosition) {
        boolean success;
        if (entity.turnOnMove()) {
            entity.setAngle(GeometricUtilities.calcRotationAngleInDegrees(entity.getLocation(), newPosition));
        }
        if (!this.isInMap(entity.getCollisionBox(newPosition))) {
            return false;
        }
        if (!entity.hasCollision()) {
            entity.setLocation(newPosition);
            return true;
        }
        boolean bl = success = !this.resolveCollisionForCurrentLocation(entity);
        if (this.resolveCollisionForNewPosition(entity, newPosition)) {
            return false;
        }
        if (this.resolveCollisionForRaycastToNewPosition(entity, newPosition)) {
            return false;
        }
        entity.setLocation(newPosition);
        return success;
    }

    private boolean resolveCollisionForCurrentLocation(IMobileEntity entity) {
        if (this.collidesWithAnything(entity, entity.getCollisionBox()) != null) {
            Point2D resolvedPosition = this.resolveCollision(entity, entity.getLocation());
            entity.setLocation(resolvedPosition);
            return true;
        }
        return false;
    }

    private boolean resolveCollisionForNewPosition(IMobileEntity entity, Point2D newPosition) {
        if (this.collidesWithAnything(entity, entity.getCollisionBox(newPosition)) != null) {
            Point2D resolvedPosition = this.resolveCollision(entity, newPosition);
            entity.setLocation(resolvedPosition);
            return true;
        }
        return false;
    }

    private boolean resolveCollisionForRaycastToNewPosition(IMobileEntity entity, Point2D newPosition) {
        Line2D.Double line = new Line2D.Double(entity.getCollisionBox().getCenterX(), entity.getCollisionBox().getCenterY(), entity.getCollisionBox(newPosition).getCenterX(), entity.getCollisionBox(newPosition).getCenterY());
        for (CollisionBox collisionBox : this.getAllCollisionBoxesInternal()) {
            Point2D intersection;
            if (collisionBox.getEntity() != null && (collisionBox.getEntity().equals(entity) || !entity.canCollideWith(collisionBox.getEntity())) || (intersection = GeometricUtilities.getIntersectionPoint((Line2D)line, collisionBox.getCollisionBox())) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean move(IMobileEntity entity, Point2D target, float delta) {
        Point2D newPosition = GeometricUtilities.project(entity.getLocation(), target, (double)delta);
        return this.move(entity, newPosition);
    }

    @Override
    public void remove(ICollisionEntity entity) {
        Prop prop;
        if (entity instanceof Prop && (prop = (Prop)entity).isObstacle()) {
            this.remove(prop.getCollisionBox());
            return;
        }
        this.collisionEntities.remove(entity);
    }

    @Override
    public void remove(Rectangle2D staticCollisionBox) {
        this.staticCollisionBoxes.remove(staticCollisionBox);
    }

    @Override
    public void setBounds(Rectangle2D environmentBounds) {
        this.environmentBounds = environmentBounds;
    }

    @Override
    public void update() {
        this.updateAllCollisionBoxes();
    }

    private List<CollisionBox> getAllCollisionBoxesInternal() {
        if (this.allCollisionBoxes.isEmpty()) {
            this.updateAllCollisionBoxes();
        }
        return this.allCollisionBoxes;
    }

    private List<Rectangle2D> getAllCollisionBoxRectangles() {
        if (this.allCollisionBoxRectangles.isEmpty()) {
            this.updateAllCollisionBoxes();
        }
        return this.allCollisionBoxRectangles;
    }

    private List<Rectangle2D> getAllCollisionBoxRectangles(CollisionType collisionType) {
        switch (collisionType) {
            case ENTITY: {
                return this.entityCollisionBoxesRectangles;
            }
            case STATIC: {
                return this.staticCollisionBoxes;
            }
        }
        return this.getAllCollisionBoxRectangles();
    }

    private void updateAllCollisionBoxes() {
        this.allCollisionBoxes.clear();
        this.entityCollisionBoxes.clear();
        this.staticBoxes.clear();
        this.entityCollisionBoxes.addAll(this.collisionEntities.stream().filter(ICollisionEntity::hasCollision).map(x$0 -> new CollisionBox((ICollisionEntity)x$0)).collect(Collectors.toList()));
        this.staticBoxes.addAll(this.staticCollisionBoxes.stream().map(x$0 -> new CollisionBox((Rectangle2D)x$0)).collect(Collectors.toList()));
        this.allCollisionBoxes.addAll(this.entityCollisionBoxes);
        this.allCollisionBoxes.addAll(this.staticBoxes);
        this.allCollisionBoxRectangles.clear();
        this.entityCollisionBoxesRectangles.clear();
        this.entityCollisionBoxesRectangles.addAll(this.entityCollisionBoxes.stream().map(CollisionBox::getCollisionBox).collect(Collectors.toList()));
        this.allCollisionBoxRectangles.addAll(this.allCollisionBoxes.stream().map(CollisionBox::getCollisionBox).collect(Collectors.toList()));
    }

    private Rectangle2D collidesWithAnyEntity(ICollisionEntity entity, Rectangle2D collisionBox) {
        for (ICollisionEntity otherEntity : this.collisionEntities) {
            if (otherEntity == null || !otherEntity.hasCollision() || entity != null && otherEntity.equals(entity) || entity != null && !entity.canCollideWith(otherEntity) || !GeometricUtilities.intersects(otherEntity.getCollisionBox(), collisionBox)) continue;
            return otherEntity.getCollisionBox().createIntersection(collisionBox);
        }
        return null;
    }

    private boolean collidesWithAnyEntity(ICollisionEntity entity, Point2D location) {
        for (ICollisionEntity otherEntity : this.collisionEntities) {
            if (otherEntity == null || !otherEntity.hasCollision() || entity != null && otherEntity.equals(entity) || entity != null && !entity.canCollideWith(otherEntity) || !otherEntity.getCollisionBox().contains(location)) continue;
            return true;
        }
        return false;
    }

    private Rectangle2D collidesWithAnyStaticCollisionBox(Rectangle2D entityCollisionBox) {
        for (Rectangle2D collisionBox : this.staticCollisionBoxes) {
            if (!GeometricUtilities.intersects(collisionBox, entityCollisionBox)) continue;
            return collisionBox.createIntersection(entityCollisionBox);
        }
        return null;
    }

    private boolean collidesWithAnyStaticCollisionBox(Point2D location) {
        for (Rectangle2D collisionBox : this.staticCollisionBoxes) {
            if (!collisionBox.contains(location)) continue;
            return true;
        }
        return false;
    }

    private Rectangle2D collidesWithAnything(ICollisionEntity entity, Rectangle2D entityCollisionBox) {
        for (CollisionBox collisionBox : this.allCollisionBoxes) {
            if (collisionBox.getEntity() != null && (collisionBox.getEntity().equals(entity) || !entity.canCollideWith(collisionBox.getEntity()))) continue;
            if (collisionBox.getCollisionBox().contains(entityCollisionBox)) {
                return collisionBox.getCollisionBox();
            }
            if (!GeometricUtilities.intersects(collisionBox.getCollisionBox(), entityCollisionBox)) continue;
            return collisionBox.getCollisionBox().createIntersection(entityCollisionBox);
        }
        return null;
    }

    private Point2D findLocationWithoutCollision(ICollisionEntity mob, Point2D newPosition) {
        for (Point2D pointBetween : GeometricUtilities.getPointsBetweenPoints(newPosition, mob.getLocation())) {
            Rectangle2D newCollisionBox = mob.getCollisionBox(pointBetween);
            if (this.collidesWithAnyEntity(mob, newCollisionBox) != null || this.collidesWithAnyStaticCollisionBox(newCollisionBox) != null) continue;
            return pointBetween;
        }
        return mob.getLocation();
    }

    private boolean isInMap(Shape collisionBox) {
        if (this.environmentBounds == null) {
            return true;
        }
        return this.environmentBounds.contains(collisionBox.getBounds());
    }

    private Point2D resolveCollision(IMobileEntity entity, Point2D newPosition) {
        Point2D resolvedPosition = new Point2D.Double(newPosition.getX(), entity.getLocation().getY());
        Rectangle2D intersectionX = this.collidesWithAnything(entity, entity.getCollisionBox(resolvedPosition));
        if (intersectionX != null) {
            if (intersectionX.getWidth() > entity.getCollisionBox().getWidth() || intersectionX.getHeight() > entity.getCollisionBox().getHeight()) {
                resolvedPosition = this.findLocationWithoutCollision(entity, resolvedPosition);
            } else if (entity.getCollisionBox().getX() < intersectionX.getMaxX()) {
                resolvedPosition.setLocation(Math.max(entity.getLocation().getX(), resolvedPosition.getX() - intersectionX.getWidth()), resolvedPosition.getY());
            } else {
                resolvedPosition.setLocation(Math.min(entity.getLocation().getX(), resolvedPosition.getX() + intersectionX.getWidth()), resolvedPosition.getY());
            }
        }
        resolvedPosition.setLocation(resolvedPosition.getX(), newPosition.getY());
        Rectangle2D intersectionY = this.collidesWithAnything(entity, entity.getCollisionBox(resolvedPosition));
        if (intersectionY != null) {
            if (intersectionY.getWidth() > entity.getCollisionBox().getWidth() || intersectionY.getHeight() > entity.getCollisionBox().getHeight()) {
                resolvedPosition = this.findLocationWithoutCollision(entity, resolvedPosition);
            } else if (entity.getCollisionBox().getCenterY() - intersectionY.getCenterY() < 0.0) {
                resolvedPosition.setLocation(resolvedPosition.getX(), Math.max(entity.getLocation().getY(), resolvedPosition.getY() - intersectionY.getHeight()));
            } else {
                resolvedPosition.setLocation(resolvedPosition.getX(), Math.min(entity.getLocation().getY(), resolvedPosition.getY() + intersectionY.getHeight()));
            }
        }
        return resolvedPosition;
    }

    private class CollisionBox {
        private final Rectangle2D box;
        private final ICollisionEntity entity;

        private CollisionBox(Rectangle2D box) {
            this.box = box;
            this.entity = null;
        }

        private CollisionBox(ICollisionEntity entity) {
            this.box = entity.getCollisionBox();
            this.entity = entity;
        }

        public Rectangle2D getCollisionBox() {
            return this.box;
        }

        public ICollisionEntity getEntity() {
            return this.entity;
        }
    }
}

