/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.physics;

import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class Force {
    private boolean cancelOnCollision;
    private boolean cancelOnReached;
    private boolean hasEnded;
    private Point2D location;
    private final float size;
    private final float strength;

    public Force(Point2D location, float strength, float size) {
        this.location = location;
        this.strength = strength;
        this.size = size;
        this.cancelOnCollision = true;
        this.cancelOnReached = true;
    }

    public boolean cancelOnCollision() {
        return this.cancelOnCollision;
    }

    public boolean cancelOnReached() {
        return this.cancelOnReached;
    }

    public void end() {
        this.hasEnded = true;
    }

    public Point2D getLocation() {
        return this.location;
    }

    public float getStrength() {
        return this.strength;
    }

    public boolean hasEnded() {
        return this.hasEnded;
    }

    public boolean hasReached(ICollisionEntity entity) {
        return new Ellipse2D.Double(this.getLocation().getX() - (double)this.size * 0.5, this.getLocation().getY() - (double)this.size * 0.5, this.size, this.size).intersects(entity.getCollisionBox());
    }

    public void setCancelOnCollision(boolean cancelOnCollision) {
        this.cancelOnCollision = cancelOnCollision;
    }

    public void setCancelOnReached(boolean cancelOnReached) {
        this.cancelOnReached = cancelOnReached;
    }

    public void setLocation(Point2D location) {
        this.location = location;
    }
}

