/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.pathfinding.astar;

import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.pathfinding.Path;
import de.gurkenlabs.litiengine.pathfinding.PathFinder;
import de.gurkenlabs.litiengine.pathfinding.astar.AStarGrid;
import de.gurkenlabs.litiengine.pathfinding.astar.AStarNode;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AStarPathFinder
extends PathFinder {
    private final AStarGrid grid;

    public AStarPathFinder(AStarGrid grid) {
        this.grid = grid;
    }

    public AStarPathFinder(Dimension size, int gridNodeSize) {
        this.grid = new AStarGrid(size, gridNodeSize);
    }

    public AStarPathFinder(IMap map, int gridNodeSize) {
        this(map.getSizeInPixels(), gridNodeSize);
    }

    public AStarPathFinder(IMap map) {
        this(map.getSizeInPixels(), map.getTileSize().width);
    }

    @Override
    public Path findPath(IMobileEntity entity, Point2D target) {
        AStarNode targetNode;
        Point2D startLocation = entity.getCollisionBoxCenter();
        if (!this.intersectsWithAnyCollisionBox(entity, startLocation, target)) {
            return this.findDirectPath(startLocation, target);
        }
        AStarNode startNode = this.getGrid().getNode(startLocation);
        if (startNode.equals(targetNode = this.getGrid().getNode(target))) {
            return null;
        }
        boolean gotoNeighbor = false;
        if (!targetNode.isWalkable()) {
            for (AStarNode neighbor : this.getGrid().getNeighbors(targetNode)) {
                if (!neighbor.isWalkable()) continue;
                targetNode = neighbor;
                gotoNeighbor = true;
                break;
            }
            if (!gotoNeighbor) {
                return this.findDirectPath(startLocation, target);
            }
        }
        if (gotoNeighbor && startNode.equals(targetNode)) {
            return null;
        }
        return this.findAStarPath(startNode, targetNode);
    }

    public AStarGrid getGrid() {
        return this.grid;
    }

    private Path findAStarPath(AStarNode startNode, AStarNode targetNode) {
        ArrayList<AStarNode> opened = new ArrayList<AStarNode>();
        ArrayList<AStarNode> closed = new ArrayList<AStarNode>();
        opened.add(startNode);
        while (!opened.isEmpty()) {
            AStarNode currentNode = this.findNodeWithLowestCost(opened);
            opened.remove(currentNode);
            closed.add(currentNode);
            if (currentNode.equals(targetNode)) {
                Path path = this.retracePath(startNode, targetNode);
                AStarPathFinder.clear(opened);
                AStarPathFinder.clear(closed);
                return path;
            }
            this.updateAndOpenNeighborNodes(currentNode, targetNode, opened, closed);
        }
        AStarPathFinder.clear(opened);
        AStarPathFinder.clear(closed);
        return null;
    }

    private void updateAndOpenNeighborNodes(AStarNode currentNode, AStarNode targetNode, List<AStarNode> opened, List<AStarNode> closed) {
        for (AStarNode neighbor : this.grid.getNeighbors(currentNode)) {
            double newGCostOfNeighbor;
            if (!neighbor.equals(targetNode) && !neighbor.isWalkable() || closed.contains(neighbor) || !((newGCostOfNeighbor = currentNode.getGCost() + currentNode.getCosts(neighbor)) < neighbor.getGCost()) && opened.contains(neighbor)) continue;
            neighbor.setGCost(newGCostOfNeighbor);
            neighbor.setHCost(neighbor.getCosts(targetNode));
            neighbor.setPredecessor(currentNode);
            if (opened.contains(neighbor)) continue;
            opened.add(neighbor);
        }
    }

    private AStarNode findNodeWithLowestCost(List<AStarNode> openedNodes) {
        AStarNode lowestCostNode = openedNodes.get(0);
        for (int i = 1; i < openedNodes.size(); ++i) {
            if (!(openedNodes.get(i).getFCost() < lowestCostNode.getFCost()) && (openedNodes.get(i).getFCost() != lowestCostNode.getFCost() || !(openedNodes.get(i).getHCost() < lowestCostNode.getHCost()))) continue;
            lowestCostNode = openedNodes.get(i);
        }
        return lowestCostNode;
    }

    private static void clear(List<AStarNode> nodes) {
        for (AStarNode op : nodes) {
            op.clear();
        }
    }

    private Path retracePath(AStarNode startNode, AStarNode targetNode) {
        ArrayList<AStarNode> path = new ArrayList<AStarNode>();
        for (AStarNode currentNode = targetNode.getPredecessor(); currentNode != startNode; currentNode = currentNode.getPredecessor()) {
            path.add(currentNode);
        }
        Collections.reverse(path);
        GeneralPath path2D = new GeneralPath(1);
        ((Path2D)path2D).moveTo(startNode.getLocation().x, startNode.getLocation().y);
        ArrayList<Point2D> pointsOfPath = new ArrayList<Point2D>();
        for (int i = 0; i < path.size(); ++i) {
            AStarNode current = (AStarNode)path.get(i);
            Point currentPoint = new Point(current.getLocation().x, current.getLocation().y);
            pointsOfPath.add(currentPoint);
            ((Path2D)path2D).lineTo(currentPoint.x, currentPoint.y);
        }
        ((Path2D)path2D).lineTo(targetNode.getLocation().x, targetNode.getLocation().y);
        return new Path(startNode.getLocation(), targetNode.getLocation(), path2D, pointsOfPath);
    }
}

