/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.pathfinding.astar;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.Prop;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.pathfinding.astar.AStarNode;
import de.gurkenlabs.litiengine.physics.CollisionType;
import de.gurkenlabs.litiengine.util.MathUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class AStarGrid
implements IRenderable {
    public static final double PENALTY_STATIC_PROP = 5.0;
    public static final double PENALTY_NOT_WALKABLE_NEIGHBOR = 4.0;
    private final AStarNode[][] grid;
    private final int nodeSize;
    private final Dimension size;
    private boolean allowDiagonalMovement = true;
    private boolean allowCuttingCorners;

    public AStarGrid(int width, int height, int nodeSize) {
        this(new Dimension(width, height), nodeSize);
    }

    public AStarGrid(Dimension size, int nodeSize) {
        this.size = size;
        this.nodeSize = nodeSize;
        int gridSizeX = this.size.width / nodeSize;
        int gridSizeY = this.size.height / nodeSize;
        this.grid = new AStarNode[gridSizeX][gridSizeY];
        this.populateGrid(gridSizeX, gridSizeY);
    }

    public boolean isDiagonalMovementAllowed() {
        return this.allowDiagonalMovement;
    }

    public boolean isDiagonalCornerMovementAllowed() {
        return this.allowCuttingCorners;
    }

    public AStarNode[][] getGrid() {
        return this.grid;
    }

    public List<AStarNode> getIntersectedNodes(Rectangle2D rectangle) {
        Point2D.Double start = new Point2D.Double(rectangle.getMinX(), rectangle.getMinY());
        Point2D.Double end = new Point2D.Double(rectangle.getMaxX(), rectangle.getMaxY());
        AStarNode startNode = this.getNode(start);
        AStarNode endNode = this.getNode(end);
        ArrayList<AStarNode> nodes = new ArrayList<AStarNode>();
        if (startNode == null || endNode == null) {
            return nodes;
        }
        for (int x = startNode.getGridX(); x <= endNode.getGridX(); ++x) {
            for (int y = startNode.getGridY(); y <= endNode.getGridY(); ++y) {
                nodes.add(this.getGrid()[x][y]);
            }
        }
        return nodes;
    }

    public List<AStarNode> getNeighbors(AStarNode node) {
        ArrayList<AStarNode> newNeighbors = new ArrayList<AStarNode>();
        int x = node.getGridX();
        int y = node.getGridY();
        AStarNode top = this.getNode(x, y - 1);
        AStarNode bottom = this.getNode(x, y + 1);
        AStarNode left = this.getNode(x - 1, y);
        AStarNode right = this.getNode(x + 1, y);
        AStarGrid.addNode(newNeighbors, top);
        AStarGrid.addNode(newNeighbors, bottom);
        AStarGrid.addNode(newNeighbors, right);
        AStarGrid.addNode(newNeighbors, left);
        if (this.isDiagonalMovementAllowed()) {
            AStarNode topLeft = this.getNode(x - 1, y - 1);
            AStarNode topRight = this.getNode(x + 1, y - 1);
            AStarNode bottomLeft = this.getNode(x - 1, y + 1);
            AStarNode bottomRight = this.getNode(x + 1, y + 1);
            this.addDiagonalNode(newNeighbors, topLeft, top, left);
            this.addDiagonalNode(newNeighbors, topRight, top, right);
            this.addDiagonalNode(newNeighbors, bottomLeft, bottom, left);
            this.addDiagonalNode(newNeighbors, bottomRight, bottom, right);
        }
        return newNeighbors;
    }

    public AStarNode getNode(Point2D point) {
        return this.getNode(point.getX(), point.getY());
    }

    public AStarNode getNode(double x, double y) {
        int xNode = (int)(x / (double)this.nodeSize);
        int yNode = (int)(y / (double)this.nodeSize);
        if (xNode >= this.getGrid().length || yNode >= this.getGrid()[0].length) {
            return null;
        }
        return this.getNode(xNode, yNode);
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    public Dimension getSize() {
        return this.size;
    }

    @Override
    public void render(Graphics2D g) {
        Rectangle2D viewport = Game.getCamera().getViewPort();
        AStarNode startNode = this.getNode(viewport.getX(), viewport.getY());
        AStarNode endNode = this.getNode(viewport.getMaxX(), viewport.getMaxY());
        int startX = MathUtilities.clamp(startNode.getGridX(), 0, this.getGrid().length - 1);
        int endX = MathUtilities.clamp(endNode.getGridX(), 0, this.getGrid().length - 1);
        int startY = MathUtilities.clamp(startNode.getGridY(), 0, this.getGrid()[0].length - 1);
        int endY = MathUtilities.clamp(endNode.getGridY(), 0, this.getGrid()[0].length - 1);
        g.setColor(new Color(255, 0, 255, 100));
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                AStarNode node = this.getGrid()[x][y];
                if (node.isWalkable()) {
                    Game.getRenderEngine().renderShape(g, new Rectangle2D.Double((double)node.getLocation().x - 0.25, (double)node.getLocation().y - 0.25, 0.5, 0.5));
                    continue;
                }
                Game.getRenderEngine().renderShape(g, node.getBounds());
            }
        }
    }

    public void setAllowDiagonalMovement(boolean allowDiagonalMovement) {
        this.allowDiagonalMovement = allowDiagonalMovement;
    }

    public void setAllowCuttingCorners(boolean allowCuttingCorners) {
        this.allowCuttingCorners = allowCuttingCorners;
    }

    public void updateWalkable(Rectangle2D rectangle) {
        for (AStarNode node : this.getIntersectedNodes(rectangle)) {
            node.setWalkable(!Game.getPhysicsEngine().collides(node.getBounds(), CollisionType.STATIC));
        }
    }

    protected void assignPenalty(AStarNode node) {
        if (!Game.getPhysicsEngine().collides((Point2D)node.getLocation(), CollisionType.ENTITY)) {
            return;
        }
        int penalty = 0;
        for (Prop prop : Game.getEnvironment().getProps()) {
            if (!prop.hasCollision() || !prop.isIndestructible() || !prop.getBoundingBox().intersects(node.getBounds())) continue;
            penalty = (int)((double)penalty + 5.0);
        }
        for (AStarNode neighbor : this.getNeighbors(node)) {
            if (neighbor.isWalkable()) continue;
            penalty = (int)((double)penalty + 4.0);
        }
        node.setPenalty(penalty);
    }

    private static void addNode(List<AStarNode> neighbors, AStarNode node) {
        if (node != null && node.isWalkable()) {
            neighbors.add(node);
        }
    }

    private void addDiagonalNode(List<AStarNode> neighbors, AStarNode node, AStarNode diagonalNeighbor1, AStarNode diagonalNeighbor2) {
        if (node != null && this.isDiagonalCornerMovementAllowed() || node != null && diagonalNeighbor1 != null && diagonalNeighbor1.isWalkable() && diagonalNeighbor2 != null && diagonalNeighbor2.isWalkable()) {
            neighbors.add(node);
        }
    }

    private AStarNode getNode(int x, int y) {
        if (x >= 0 && x < this.getGrid().length && y >= 0 && y < this.getGrid()[0].length) {
            return this.getGrid()[x][y];
        }
        return null;
    }

    private void populateGrid(int gridSizeX, int gridSizeY) {
        for (int x = 0; x < gridSizeX; ++x) {
            for (int y = 0; y < gridSizeY; ++y) {
                Rectangle nodeBounds = new Rectangle(x * this.nodeSize, y * this.nodeSize, this.nodeSize, this.nodeSize);
                AStarNode node = new AStarNode(!Game.getPhysicsEngine().collides(nodeBounds, CollisionType.STATIC), nodeBounds, x, y);
                this.assignPenalty(node);
                this.getGrid()[x][y] = node;
            }
        }
    }
}

