/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.pathfinding;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.pathfinding.IEntityNavigator;
import de.gurkenlabs.litiengine.pathfinding.IPathFinder;
import de.gurkenlabs.litiengine.pathfinding.Path;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;

public class EntityNavigator
implements IEntityNavigator {
    private static final float ACCEPTABLE_ERROR = 0.3f;
    private final List<Predicate<IMobileEntity>> cancelNavigationConditions = new CopyOnWriteArrayList<Predicate<IMobileEntity>>();
    private int currentSegment;
    private final IMobileEntity entity;
    private Path path;
    private final IPathFinder pathFinder;

    public EntityNavigator(IMobileEntity entity, IPathFinder pathFinder) {
        this.entity = entity;
        this.pathFinder = pathFinder;
        Game.getLoop().attach(this);
    }

    @Override
    public void cancelNavigation(Predicate<IMobileEntity> predicate) {
        if (!this.cancelNavigationConditions.contains(predicate)) {
            this.cancelNavigationConditions.add(predicate);
        }
    }

    @Override
    public IMobileEntity getEntity() {
        return this.entity;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public IPathFinder getPathFinder() {
        return this.pathFinder;
    }

    @Override
    public boolean isNavigating() {
        return this.path != null;
    }

    @Override
    public boolean navigate(Path2D path) {
        this.path = new Path(path);
        return this.path != null;
    }

    @Override
    public boolean navigate(Point2D target) {
        if (this.getPathFinder() != null) {
            this.path = this.getPathFinder().findPath(this.entity, target);
        }
        return this.path != null;
    }

    @Override
    public void render(Graphics2D g) {
        if (this.getPath() == null) {
            return;
        }
        g.setColor(Color.MAGENTA);
        Game.getRenderEngine().renderOutline(g, this.getPath().getPath());
    }

    @Override
    public void rotateTowards(Point2D target) {
        double angle = GeometricUtilities.calcRotationAngleInDegrees(this.entity.getCollisionBox().getCenterX(), this.entity.getCollisionBox().getCenterY(), target.getX(), target.getY());
        this.entity.setAngle((float)angle);
    }

    @Override
    public void stop() {
        this.currentSegment = 0;
        this.path = null;
    }

    @Override
    public void update() {
        if (!this.isNavigating()) {
            return;
        }
        if (this.path == null) {
            return;
        }
        for (Predicate<IMobileEntity> pred : this.cancelNavigationConditions) {
            if (!pred.test(this.getEntity())) continue;
            this.stop();
            return;
        }
        PathIterator pi = this.path.getPath().getPathIterator(null);
        if (pi.isDone()) {
            this.stop();
            return;
        }
        double[] startCoordinates = new double[22];
        double[] coordinates = new double[22];
        for (int i = 0; i <= this.currentSegment; ++i) {
            if (pi.isDone()) {
                this.stop();
                return;
            }
            pi.currentSegment(startCoordinates);
            pi.next();
        }
        if (pi.isDone()) {
            this.stop();
            return;
        }
        pi.currentSegment(coordinates);
        double distance = GeometricUtilities.distance(this.entity.getCollisionBox().getCenterX(), this.entity.getCollisionBox().getCenterY(), coordinates[0], coordinates[1]);
        if (distance < (double)0.3f) {
            ++this.currentSegment;
            return;
        }
        double angle = GeometricUtilities.calcRotationAngleInDegrees(this.entity.getCollisionBox().getCenterX(), this.entity.getCollisionBox().getCenterY(), coordinates[0], coordinates[1]);
        float pixelsPerTick = this.entity.getTickVelocity();
        Game.getPhysicsEngine().move(this.entity, (float)angle, (double)((float)(distance < (double)pixelsPerTick ? distance : (double)pixelsPerTick)));
    }
}

