/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.net;

import de.gurkenlabs.litiengine.net.IPacketSender;
import de.gurkenlabs.litiengine.net.Packet;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UdpPacketSender
implements IPacketSender {
    private static final Logger log = Logger.getLogger(UdpPacketSender.class.getName());
    private DatagramSocket socket;

    public UdpPacketSender() {
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public DatagramSocket getSenderSocket() {
        return this.socket;
    }

    @Override
    public void sendData(Packet packet, InetAddress ipAddress, int port) {
        DatagramPacket datagramPacket = new DatagramPacket(packet.getData(), packet.getData().length, ipAddress, port);
        try {
            this.socket.send(datagramPacket);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void sendData(Packet packet, String ipAddress, int port) {
        try {
            this.sendData(packet, InetAddress.getByName(ipAddress), port);
        }
        catch (UnknownHostException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

