/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.input.IMouse;
import de.gurkenlabs.litiengine.util.MathUtilities;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class Mouse
implements IMouse {
    private static final Logger log = Logger.getLogger(Mouse.class.getName());
    private final List<Consumer<MouseEvent>> mouseClickedConsumer = new CopyOnWriteArrayList<Consumer<MouseEvent>>();
    private final List<Consumer<MouseEvent>> mouseDraggedConsumer = new CopyOnWriteArrayList<Consumer<MouseEvent>>();
    private final List<MouseListener> mouseListeners = new CopyOnWriteArrayList<MouseListener>();
    private final List<MouseMotionListener> mouseMotionListeners = new CopyOnWriteArrayList<MouseMotionListener>();
    private final List<Consumer<MouseEvent>> mouseMovedConsumer = new CopyOnWriteArrayList<Consumer<MouseEvent>>();
    private final List<Consumer<MouseEvent>> mousePressedConsumer = new CopyOnWriteArrayList<Consumer<MouseEvent>>();
    private final List<Consumer<MouseEvent>> mouseReleasedConsumer = new CopyOnWriteArrayList<Consumer<MouseEvent>>();
    private final List<MouseWheelListener> mouseWheelListeners = new CopyOnWriteArrayList<MouseWheelListener>();
    private final List<Consumer<MouseWheelEvent>> wheelMovedConsumer = new CopyOnWriteArrayList<Consumer<MouseWheelEvent>>();
    private final Robot robot;
    private final float sensitivity;
    private boolean grabMouse;
    private boolean pressed;
    private boolean isLeftMouseButtonDown;
    private boolean isRightMouseButtonDown;
    private Point2D lastLocation;
    private Point2D location;

    public Mouse() throws AWTException {
        try {
            this.robot = new Robot();
            this.robot.setAutoDelay(0);
        }
        catch (AWTException e) {
            log.log(Level.SEVERE, "The mouse input could not be initialized.");
            throw e;
        }
        this.lastLocation = this.location = new Point2D.Double(Game.getCamera().getViewPort().getCenterX(), Game.getCamera().getViewPort().getCenterY());
        this.sensitivity = Game.getConfiguration().input().getMouseSensitivity();
        this.grabMouse = true;
    }

    @Override
    public Point2D getLocation() {
        return this.location;
    }

    @Override
    public Point2D getMapLocation() {
        return Game.getCamera().getMapLocation(new Point2D.Double(this.getLocation().getX() / (double)Game.getCamera().getRenderScale(), this.getLocation().getY() / (double)Game.getCamera().getRenderScale()));
    }

    @Override
    public Point getTile() {
        return MapUtilities.getTile(this.getMapLocation());
    }

    @Override
    public boolean isGrabMouse() {
        return this.grabMouse;
    }

    @Override
    public boolean isLeftMouseButtonDown() {
        return this.isLeftMouseButtonDown;
    }

    @Override
    public boolean isPressed() {
        return this.pressed;
    }

    @Override
    public boolean isRightMouseButtonDown() {
        return this.isRightMouseButtonDown;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.setLocation(e);
        MouseEvent wrappedEvent = this.createEvent(e);
        this.mouseListeners.forEach(listener -> listener.mouseClicked(wrappedEvent));
        for (Consumer<MouseEvent> cons : this.mouseClickedConsumer) {
            cons.accept(wrappedEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.setLocation(e);
        MouseEvent wrappedEvent = this.createEvent(e);
        this.mouseMotionListeners.forEach(listener -> listener.mouseDragged(wrappedEvent));
        for (Consumer<MouseEvent> cons : this.mouseDraggedConsumer) {
            cons.accept(wrappedEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.grabMouse) {
            this.lastLocation = e.getPoint();
            this.location = e.getPoint();
        } else {
            this.setLocation(e);
        }
        MouseEvent wrappedEvent = this.createEvent(e);
        this.mouseListeners.forEach(listener -> listener.mouseEntered(wrappedEvent));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setLocation(e);
        MouseEvent wrappedEvent = this.createEvent(e);
        this.mouseListeners.forEach(listener -> listener.mouseExited(wrappedEvent));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setLocation(e);
        MouseEvent wrappedEvent = this.createEvent(e);
        this.mouseMotionListeners.forEach(listener -> listener.mouseMoved(wrappedEvent));
        for (Consumer<MouseEvent> cons : this.mouseMovedConsumer) {
            cons.accept(wrappedEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setLocation(e);
        this.setPressed(true);
        MouseEvent wrappedEvent = this.createEvent(e);
        this.mouseListeners.forEach(listener -> listener.mousePressed(wrappedEvent));
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.isLeftMouseButtonDown = true;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            this.isRightMouseButtonDown = true;
        }
        for (Consumer<MouseEvent> cons : this.mousePressedConsumer) {
            cons.accept(wrappedEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setLocation(e);
        this.setPressed(false);
        MouseEvent wrappedEvent = this.createEvent(e);
        this.mouseListeners.forEach(listener -> listener.mouseReleased(wrappedEvent));
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.isLeftMouseButtonDown = false;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            this.isRightMouseButtonDown = false;
        }
        for (Consumer<MouseEvent> cons : this.mouseReleasedConsumer) {
            cons.accept(wrappedEvent);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.mouseWheelListeners.forEach(listener -> listener.mouseWheelMoved(e));
        this.wheelMovedConsumer.forEach(cons -> cons.accept(e));
    }

    @Override
    public void onClicked(Consumer<MouseEvent> consumer) {
        this.mouseClickedConsumer.add(consumer);
    }

    @Override
    public void onDragged(Consumer<MouseEvent> consumer) {
        this.mouseDraggedConsumer.add(consumer);
    }

    @Override
    public void onMoved(Consumer<MouseEvent> consumer) {
        this.mouseMovedConsumer.add(consumer);
    }

    @Override
    public void onPressed(Consumer<MouseEvent> consumer) {
        this.mousePressedConsumer.add(consumer);
    }

    @Override
    public void onReleased(Consumer<MouseEvent> consumer) {
        this.mouseReleasedConsumer.add(consumer);
    }

    @Override
    public void onWheelMoved(Consumer<MouseWheelEvent> consumer) {
        this.wheelMovedConsumer.add(consumer);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        if (this.mouseListeners.contains(listener)) {
            return;
        }
        this.mouseListeners.add(listener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener listener) {
        if (this.mouseMotionListeners.contains(listener)) {
            return;
        }
        this.mouseMotionListeners.add(listener);
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener listener) {
        if (this.mouseWheelListeners.contains(listener)) {
            return;
        }
        this.mouseWheelListeners.add(listener);
    }

    @Override
    public void setGrabMouse(boolean grab) {
        this.grabMouse = grab;
    }

    @Override
    public void setLocation(Point2D adjustMouse) {
        if (adjustMouse == null) {
            return;
        }
        this.location = adjustMouse;
        this.lastLocation = adjustMouse;
        MouseEvent mouseEvent = new MouseEvent(Game.getScreenManager().getRenderComponent(), 503, 0L, 0, (int)this.getLocation().getX(), (int)this.getLocation().getY(), 0, false, 0);
        MouseEvent wrappedEvent = this.createEvent(mouseEvent);
        for (Consumer<MouseEvent> cons : this.mouseMovedConsumer) {
            cons.accept(wrappedEvent);
        }
    }

    @Override
    public void setLocation(double x, double y) {
        this.setLocation(new Point2D.Double(x, y));
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        this.mouseListeners.remove(listener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListeners.remove(listener);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.mouseWheelListeners.remove(listener);
    }

    private MouseEvent createEvent(MouseEvent original) {
        return new MouseEvent(original.getComponent(), original.getID(), original.getWhen(), original.getModifiers(), (int)this.getLocation().getX(), (int)this.getLocation().getY(), original.getXOnScreen(), original.getYOnScreen(), original.getClickCount(), original.isPopupTrigger(), original.getButton());
    }

    private void setLocation(MouseEvent e) {
        double diffY;
        double diffX;
        if (this.grabMouse && !Game.getScreenManager().isFocusOwner()) {
            return;
        }
        if (!this.grabMouse) {
            diffX = (double)e.getX() - this.lastLocation.getX();
            diffY = (double)e.getY() - this.lastLocation.getY();
            this.lastLocation = new Point(e.getPoint().x - Game.getScreenManager().getRenderComponent().getCursorOffsetX(), e.getPoint().y - Game.getScreenManager().getRenderComponent().getCursorOffsetY());
        } else {
            double screenCenterX = Game.getScreenManager().getResolution().getWidth() * 0.5;
            double screenCenterY = Game.getScreenManager().getResolution().getHeight() * 0.5;
            Point screenLocation = Game.getScreenManager().getScreenLocation();
            int grabX = (int)((double)screenLocation.x + screenCenterX);
            int grabY = (int)((double)screenLocation.y + screenCenterY);
            this.robot.mouseMove(grabX, grabY);
            diffX = (double)e.getXOnScreen() - (double)grabX;
            diffY = (double)e.getYOnScreen() - (double)grabY;
        }
        double newX = this.getLocation().getX() + diffX * (double)this.sensitivity;
        double newY = this.getLocation().getY() + diffY * (double)this.sensitivity;
        newX = MathUtilities.clamp(newX, 0.0, Game.getScreenManager().getResolution().getWidth());
        newY = MathUtilities.clamp(newY, 0.0, Game.getScreenManager().getResolution().getHeight());
        this.location = new Point2D.Double(newX, newY);
    }

    private void setPressed(boolean pressed) {
        this.pressed = pressed;
    }
}

