/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.physics.AccelerationMovementController;
import de.gurkenlabs.litiengine.util.ListUtilities;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;

public class KeyboardEntityController<T extends IMobileEntity>
extends AccelerationMovementController<T> {
    private final List<Integer> up = new ArrayList<Integer>();
    private final List<Integer> down = new ArrayList<Integer>();
    private final List<Integer> left = new ArrayList<Integer>();
    private final List<Integer> right = new ArrayList<Integer>();

    public KeyboardEntityController(T entity) {
        this(entity, 87, 83, 65, 68);
    }

    public KeyboardEntityController(T entity, int up, int down, int left, int right) {
        super(entity);
        this.up.add(up);
        this.down.add(down);
        this.left.add(left);
        this.right.add(right);
        Input.keyboard().onKeyPressed(this::handlePressedKey);
    }

    public void handlePressedKey(KeyEvent keyCode) {
        if (this.up.contains(keyCode.getKeyCode())) {
            this.setDy(this.getDy() - 1.0f);
            this.setMovedY(true);
        } else if (this.down.contains(keyCode.getKeyCode())) {
            this.setMovedY(true);
            this.setDy(this.getDy() + 1.0f);
        } else if (this.left.contains(keyCode.getKeyCode())) {
            this.setDx(this.getDx() - 1.0f);
            this.setMovedX(true);
        } else if (this.right.contains(keyCode.getKeyCode())) {
            this.setDx(this.getDx() + 1.0f);
            this.setMovedX(true);
        }
    }

    public void addUpKey(int keyCode) {
        if (this.up.contains(keyCode)) {
            return;
        }
        this.up.add(keyCode);
    }

    public void addDownKey(int keyCode) {
        if (this.down.contains(keyCode)) {
            return;
        }
        this.down.add(keyCode);
    }

    public void addLeftKey(int keyCode) {
        if (this.left.contains(keyCode)) {
            return;
        }
        this.left.add(keyCode);
    }

    public void addRightKey(int keyCode) {
        if (this.right.contains(keyCode)) {
            return;
        }
        this.right.add(keyCode);
    }

    public List<Integer> getUpKeys() {
        return this.up;
    }

    public List<Integer> getDownKeys() {
        return this.down;
    }

    public List<Integer> getLeftKeys() {
        return this.left;
    }

    public List<Integer> getRightKeys() {
        return this.right;
    }

    public void setUpKeys(int ... up) {
        this.setUpKeys(ListUtilities.getIntList(up));
    }

    public void setUpKeys(List<Integer> up) {
        KeyboardEntityController.set(this.up, up);
    }

    public void setDownKeys(int ... down) {
        this.setDownKeys(ListUtilities.getIntList(down));
    }

    public void setDownKeys(List<Integer> down) {
        KeyboardEntityController.set(this.down, down);
    }

    public void setLeftKeys(int ... left) {
        this.setLeftKeys(ListUtilities.getIntList(left));
    }

    public void setLeftKeys(List<Integer> left) {
        KeyboardEntityController.set(this.left, left);
    }

    public void setRightKeys(int ... right) {
        this.setRightKeys(ListUtilities.getIntList(right));
    }

    public void setRightKeys(List<Integer> right) {
        KeyboardEntityController.set(this.right, right);
    }

    private static void set(List<Integer> keyList, List<Integer> keys) {
        keyList.clear();
        for (int key : keys) {
            keyList.add(key);
        }
    }
}

