/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.GameLoop;
import de.gurkenlabs.litiengine.IGameLoop;
import de.gurkenlabs.litiengine.input.GamepadManager;
import de.gurkenlabs.litiengine.input.IGamepad;
import de.gurkenlabs.litiengine.input.IGamepadManager;
import de.gurkenlabs.litiengine.input.IKeyboard;
import de.gurkenlabs.litiengine.input.IMouse;
import de.gurkenlabs.litiengine.input.KeyBoard;
import de.gurkenlabs.litiengine.input.Mouse;
import java.awt.AWTException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Input {
    private static final IGameLoop InputLoop = new GameLoop("Input Loop", Game.getLoop().getUpdateRate());
    private static IGamepadManager gamePadManager;
    private static List<IGamepad> gamePads;
    private static IKeyboard keyboard;
    private static IMouse mouse;

    private Input() {
    }

    public static void init() throws AWTException {
        keyboard = new KeyBoard();
        mouse = new Mouse();
        if (Game.getConfiguration().input().isGamepadSupport()) {
            gamePads = new CopyOnWriteArrayList<IGamepad>();
            gamePadManager = new GamepadManager();
        }
    }

    public static void start() {
        InputLoop.start();
        if (gamePadManager != null) {
            gamePadManager.start();
        }
    }

    public static void terminate() {
        InputLoop.terminate();
        if (gamePadManager != null) {
            gamePadManager.terminate();
        }
    }

    public static IGameLoop getLoop() {
        return InputLoop;
    }

    public static IGamepadManager gamepadManager() {
        return gamePadManager;
    }

    public static IKeyboard keyboard() {
        return keyboard;
    }

    public static IMouse mouse() {
        return mouse;
    }

    public static List<IGamepad> gamepads() {
        return gamePads;
    }

    public static IGamepad getGamepad() {
        if (gamePads.isEmpty()) {
            return null;
        }
        return gamePads.get(0);
    }

    public static IGamepad getGamepad(int index) {
        if (gamePads.isEmpty()) {
            return null;
        }
        for (IGamepad gamepad : gamePads) {
            if (gamepad.getIndex() != index) continue;
            return gamepad;
        }
        return null;
    }
}

