/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.GameAdapter;
import de.gurkenlabs.litiengine.input.Gamepad;
import de.gurkenlabs.litiengine.input.IGamepad;
import de.gurkenlabs.litiengine.input.IGamepadManager;
import de.gurkenlabs.litiengine.input.Input;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;

public class GamepadManager
implements IGamepadManager {
    private static final Logger log = Logger.getLogger(GamepadManager.class.getName());
    private final List<Consumer<IGamepad>> gamepadAddedConsumer;
    private final List<Consumer<IGamepad>> gamepadRemovedConsumer = new CopyOnWriteArrayList<Consumer<IGamepad>>();
    private final Map<String, List<Consumer<Float>>> componentPollConsumer;
    private final Map<String, List<Consumer<Float>>> componentPressedConsumer;
    private final Map<String, List<Consumer<Float>>> componentReleasedConsumer;
    private final List<BiConsumer<String, Float>> pollConsumer;
    private final List<BiConsumer<String, Float>> pressedConsumer;
    private final List<BiConsumer<String, Float>> releasedConsumer;
    private final Thread hotPlugThread;
    private int defaultgamePadIndex = -1;
    private boolean handleHotPluggedControllers;

    public GamepadManager() {
        this.gamepadAddedConsumer = new CopyOnWriteArrayList<Consumer<IGamepad>>();
        this.componentPollConsumer = new ConcurrentHashMap<String, List<Consumer<Float>>>();
        this.componentPressedConsumer = new ConcurrentHashMap<String, List<Consumer<Float>>>();
        this.componentReleasedConsumer = new ConcurrentHashMap<String, List<Consumer<Float>>>();
        this.pollConsumer = new CopyOnWriteArrayList<BiConsumer<String, Float>>();
        this.pressedConsumer = new CopyOnWriteArrayList<BiConsumer<String, Float>>();
        this.releasedConsumer = new CopyOnWriteArrayList<BiConsumer<String, Float>>();
        this.hotPlugThread = new Thread(() -> {
            while (!Thread.interrupted()) {
                this.updateGamepads();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        });
        Game.addGameListener(new GameAdapter(){

            @Override
            public void terminated() {
                GamepadManager.this.hotPlugThread.interrupt();
            }
        });
        this.onGamepadAdded(pad -> {
            if (this.defaultgamePadIndex == -1) {
                this.defaultgamePadIndex = pad.getIndex();
                this.hookupToGamepad((IGamepad)pad);
            }
        });
        this.onGamepadRemoved(pad -> {
            if (this.defaultgamePadIndex == pad.getIndex()) {
                this.defaultgamePadIndex = -1;
                IGamepad newGamePad = Input.getGamepad();
                if (newGamePad != null) {
                    this.defaultgamePadIndex = newGamePad.getIndex();
                    this.hookupToGamepad(newGamePad);
                }
            }
        });
    }

    @Override
    public void onGamepadAdded(Consumer<IGamepad> cons) {
        this.gamepadAddedConsumer.add(cons);
    }

    @Override
    public void onGamepadRemoved(Consumer<IGamepad> cons) {
        this.gamepadRemovedConsumer.add(cons);
    }

    @Override
    public void onPoll(String identifier, Consumer<Float> consumer) {
        GamepadManager.addComponentConsumer(this.componentPollConsumer, identifier, consumer);
    }

    @Override
    public void onPoll(BiConsumer<String, Float> consumer) {
        if (this.pollConsumer.contains(consumer)) {
            return;
        }
        this.pollConsumer.add(consumer);
    }

    @Override
    public void onPressed(String identifier, Consumer<Float> consumer) {
        GamepadManager.addComponentConsumer(this.componentPressedConsumer, identifier, consumer);
    }

    @Override
    public void onPressed(BiConsumer<String, Float> consumer) {
        if (this.pressedConsumer.contains(consumer)) {
            return;
        }
        this.pressedConsumer.add(consumer);
    }

    @Override
    public void onReleased(String identifier, Consumer<Float> consumer) {
        GamepadManager.addComponentConsumer(this.componentReleasedConsumer, identifier, consumer);
    }

    @Override
    public void onReleased(BiConsumer<String, Float> consumer) {
        if (this.releasedConsumer.contains(consumer)) {
            return;
        }
        this.releasedConsumer.add(consumer);
    }

    @Override
    public void remove(IGamepad gamepad) {
        if (gamepad == null) {
            return;
        }
        Input.gamepads().remove(gamepad);
        for (Consumer<IGamepad> cons : this.gamepadRemovedConsumer) {
            cons.accept(gamepad);
        }
    }

    @Override
    public void start() {
        this.hotPlugThread.start();
    }

    @Override
    public void terminate() {
        for (int totalWait = 0; this.handleHotPluggedControllers && totalWait <= 40; ++totalWait) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        this.hotPlugThread.interrupt();
    }

    protected static void addComponentConsumer(Map<String, List<Consumer<Float>>> consumerList, String identifier, Consumer<Float> consumer) {
        if (!consumerList.containsKey(identifier)) {
            consumerList.put(identifier, new ArrayList());
        }
        consumerList.get(identifier).add(consumer);
    }

    private void hackTheShitOutOfJInputBecauseItSucksHard() {
        try {
            Field env = ControllerEnvironment.class.getDeclaredField("defaultEnvironment");
            env.setAccessible(true);
            Class<?> clazz = Class.forName("net.java.games.input.DefaultControllerEnvironment");
            Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
            for (Thread thread : threadSet) {
                String name = thread.getClass().getName();
                if (!name.equals("net.java.games.input.RawInputEventQueue$QueueThread")) continue;
                thread.interrupt();
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    log.log(Level.FINE, e.getMessage(), e);
                    Thread.currentThread().interrupt();
                }
            }
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            ctor.setAccessible(true);
            env.set(null, ctor.newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void hookupToGamepad(IGamepad pad) {
        for (Map.Entry<String, List<Consumer<Float>>> entry : this.componentPollConsumer.entrySet()) {
            for (Consumer<Float> cons : entry.getValue()) {
                pad.onPoll(entry.getKey(), cons);
            }
        }
        for (Map.Entry<String, List<Consumer<Float>>> entry : this.componentPressedConsumer.entrySet()) {
            for (Consumer<Float> cons : entry.getValue()) {
                pad.onPressed(entry.getKey(), cons);
            }
        }
        for (Map.Entry<String, List<Consumer<Float>>> entry : this.componentReleasedConsumer.entrySet()) {
            for (Consumer<Float> cons : entry.getValue()) {
                pad.onReleased(entry.getKey(), cons);
            }
        }
        for (BiConsumer biConsumer : this.pollConsumer) {
            pad.onPoll(biConsumer);
        }
        for (BiConsumer biConsumer : this.pressedConsumer) {
            pad.onPressed(biConsumer);
        }
        for (BiConsumer biConsumer : this.releasedConsumer) {
            pad.onReleased(biConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGamepads() {
        this.handleHotPluggedControllers = true;
        try {
            this.hackTheShitOutOfJInputBecauseItSucksHard();
            for (int i = 0; i < ControllerEnvironment.getDefaultEnvironment().getControllers().length; ++i) {
                IGamepad existing;
                Controller controller = ControllerEnvironment.getDefaultEnvironment().getControllers()[i];
                Controller.Type type = controller.getType();
                if (!type.equals(Controller.Type.GAMEPAD) || (existing = Input.getGamepad(i)) != null && existing.getName().equals(controller.getName())) continue;
                Gamepad newGamepad = new Gamepad(i, controller);
                Input.gamepads().add(newGamepad);
                for (Consumer<IGamepad> cons : this.gamepadAddedConsumer) {
                    cons.accept(newGamepad);
                }
            }
        }
        catch (IllegalStateException e) {
            this.hotPlugThread.interrupt();
        }
        finally {
            this.handleHotPluggedControllers = false;
        }
    }
}

