/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.input.GamepadManager;
import de.gurkenlabs.litiengine.input.IGamepad;
import de.gurkenlabs.litiengine.input.Input;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;

public class Gamepad
implements IGamepad,
IUpdateable {
    public static final float AXIS_DEAD_ZONE = 0.3f;
    public static final float TRIGGER_DEAD_ZONE = 0.1f;
    public static final float STICK_DEADZONE = 0.15f;
    private static final Map<String, Component.Identifier> components = new HashMap<String, Component.Identifier>();
    private final Controller controller;
    private final int index;
    private final Map<String, List<Consumer<Float>>> componentPollConsumer = new ConcurrentHashMap<String, List<Consumer<Float>>>();
    private final Map<String, List<Consumer<Float>>> componentPressedConsumer = new ConcurrentHashMap<String, List<Consumer<Float>>>();
    private final Map<String, List<Consumer<Float>>> componentReleasedConsumer = new ConcurrentHashMap<String, List<Consumer<Float>>>();
    private final List<BiConsumer<String, Float>> pollConsumer = new CopyOnWriteArrayList<BiConsumer<String, Float>>();
    private final List<BiConsumer<String, Float>> pressedConsumer = new CopyOnWriteArrayList<BiConsumer<String, Float>>();
    private final List<BiConsumer<String, Float>> releasedConsumer = new CopyOnWriteArrayList<BiConsumer<String, Float>>();
    private final List<String> pressedComponents = new CopyOnWriteArrayList<String>();

    protected Gamepad(int index, Controller controller) {
        this.index = index;
        this.controller = controller;
        Input.getLoop().attach(this);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.controller.getName();
    }

    @Override
    public float getPollData(Component.Identifier identifier) {
        Component comp = this.controller.getComponent(identifier);
        if (comp == null) {
            return 0.0f;
        }
        return comp.getPollData();
    }

    @Override
    public void onPoll(String identifier, Consumer<Float> consumer) {
        GamepadManager.addComponentConsumer(this.componentPollConsumer, identifier, consumer);
    }

    @Override
    public void onPoll(BiConsumer<String, Float> consumer) {
        if (this.pollConsumer.contains(consumer)) {
            return;
        }
        this.pollConsumer.add(consumer);
    }

    @Override
    public void onPressed(String identifier, Consumer<Float> consumer) {
        GamepadManager.addComponentConsumer(this.componentPressedConsumer, identifier, consumer);
    }

    @Override
    public void onPressed(BiConsumer<String, Float> consumer) {
        if (this.pressedConsumer.contains(consumer)) {
            return;
        }
        this.pressedConsumer.add(consumer);
    }

    @Override
    public void onReleased(String identifier, Consumer<Float> consumer) {
        GamepadManager.addComponentConsumer(this.componentReleasedConsumer, identifier, consumer);
    }

    @Override
    public void onReleased(BiConsumer<String, Float> consumer) {
        if (this.releasedConsumer.contains(consumer)) {
            return;
        }
        this.releasedConsumer.add(consumer);
    }

    @Override
    public void update() {
        boolean couldPoll = this.controller.poll();
        if (!couldPoll) {
            this.dispose();
        }
        Event event = new Event();
        while (this.controller.getEventQueue().getNextEvent(event)) {
            this.handlePollEvents(event);
        }
        for (Component comp : this.controller.getComponents()) {
            if (Math.abs(comp.getPollData()) > Gamepad.getDeadZone(comp.getIdentifier())) {
                this.handlePressed(comp);
                continue;
            }
            this.handleRelease(comp);
        }
    }

    private void handlePressed(Component comp) {
        String name = comp.getIdentifier().getName();
        for (BiConsumer<String, Float> biConsumer : this.pressedConsumer) {
            biConsumer.accept(name, Float.valueOf(comp.getPollData()));
        }
        if (this.componentPressedConsumer.containsKey(name)) {
            for (Consumer consumer : this.componentPressedConsumer.get(name)) {
                consumer.accept(Float.valueOf(comp.getPollData()));
            }
        }
        if (!this.pressedComponents.contains(name)) {
            this.pressedComponents.add(name);
        }
    }

    private static float getDeadZone(Component.Identifier ident) {
        if (ident.getName().equals(Axis.X) || ident.getName().equals(Axis.Y)) {
            return 0.3f;
        }
        if (ident.getName().equals(Axis.Z)) {
            return 0.1f;
        }
        return 0.0f;
    }

    private static final String addComponent(Component.Identifier identifier) {
        components.put(identifier.getName(), identifier);
        return identifier.getName();
    }

    protected static final Component.Identifier get(String name) {
        return components.get(name);
    }

    private void dispose() {
        Input.getLoop().detach(this);
        this.componentPollConsumer.clear();
        this.componentPressedConsumer.clear();
        Input.gamepadManager().remove(this);
    }

    private void handlePollEvents(Event event) {
        for (BiConsumer<String, Float> cons : this.pollConsumer) {
            cons.accept(event.getComponent().getIdentifier().getName(), Float.valueOf(event.getValue()));
        }
        List<Consumer<Float>> consumers = this.componentPollConsumer.get(event.getComponent().getIdentifier().getName());
        if (consumers != null) {
            for (Consumer<Float> cons : consumers) {
                cons.accept(Float.valueOf(event.getValue()));
            }
        }
    }

    private void handleRelease(Component comp) {
        String name = comp.getIdentifier().getName();
        if (!this.pressedComponents.contains(name)) {
            return;
        }
        this.pressedComponents.remove(name);
        for (BiConsumer<String, Float> cons : this.releasedConsumer) {
            cons.accept(name, Float.valueOf(comp.getPollData()));
        }
        List<Consumer<Float>> consumers = this.componentReleasedConsumer.get(comp.getIdentifier().getName());
        if (consumers != null) {
            for (Consumer<Float> cons : consumers) {
                cons.accept(Float.valueOf(comp.getPollData()));
            }
        }
    }

    static /* synthetic */ String access$000(Component.Identifier x0) {
        return Gamepad.addComponent(x0);
    }

    public static class Xbox {
        public static final String A = Buttons.BUTTON_0;
        public static final String B = Buttons.BUTTON_1;
        public static final String DPAD = Axis.POV;
        public static final String LB = Buttons.BUTTON_4;
        public static final String LEFT_STICK_PRESS = Buttons.BUTTON_8;
        public static final String LEFT_STICK_X = Axis.X;
        public static final String LEFT_STICK_Y = Axis.Y;
        public static final String LT = Axis.Z;
        public static final String RB = Buttons.BUTTON_5;
        public static final String RIGHT_STICK_PRESS = Buttons.BUTTON_9;
        public static final String RIGHT_STICK_X = Axis.RX;
        public static final String RIGHT_STICK_Y = Axis.RY;
        public static final String RT = Axis.Z;
        public static final String SELECT = Buttons.BUTTON_6;
        public static final String START = Buttons.BUTTON_7;
        public static final String X = Buttons.BUTTON_2;
        public static final String Y = Buttons.BUTTON_3;

        private Xbox() {
        }
    }

    public static class DPad {
        public static final float OFF = 0.0f;
        public static final float CENTER = 0.0f;
        public static final float DOWN = 0.75f;
        public static final float DOWN_LEFT = 0.875f;
        public static final float DOWN_RIGHT = 0.625f;
        public static final float LEFT = 1.0f;
        public static final float RIGHT = 0.5f;
        public static final float UP = 0.25f;
        public static final float UP_LEFT = 0.125f;
        public static final float UP_RIGHT = 0.375f;

        private DPad() {
        }
    }

    public static class Buttons {
        public static final String BUTTON_0 = Gamepad.access$000(Component.Identifier.Button._0);
        public static final String BUTTON_1 = Gamepad.access$000(Component.Identifier.Button._1);
        public static final String BUTTON_10 = Gamepad.access$000(Component.Identifier.Button._10);
        public static final String BUTTON_11 = Gamepad.access$000(Component.Identifier.Button._11);
        public static final String BUTTON_12 = Gamepad.access$000(Component.Identifier.Button._12);
        public static final String BUTTON_13 = Gamepad.access$000(Component.Identifier.Button._13);
        public static final String BUTTON_14 = Gamepad.access$000(Component.Identifier.Button._14);
        public static final String BUTTON_15 = Gamepad.access$000(Component.Identifier.Button._15);
        public static final String BUTTON_16 = Gamepad.access$000(Component.Identifier.Button._16);
        public static final String BUTTON_17 = Gamepad.access$000(Component.Identifier.Button._17);
        public static final String BUTTON_18 = Gamepad.access$000(Component.Identifier.Button._18);
        public static final String BUTTON_19 = Gamepad.access$000(Component.Identifier.Button._19);
        public static final String BUTTON_2 = Gamepad.access$000(Component.Identifier.Button._2);
        public static final String BUTTON_20 = Gamepad.access$000(Component.Identifier.Button._20);
        public static final String BUTTON_21 = Gamepad.access$000(Component.Identifier.Button._21);
        public static final String BUTTON_22 = Gamepad.access$000(Component.Identifier.Button._22);
        public static final String BUTTON_23 = Gamepad.access$000(Component.Identifier.Button._23);
        public static final String BUTTON_24 = Gamepad.access$000(Component.Identifier.Button._24);
        public static final String BUTTON_25 = Gamepad.access$000(Component.Identifier.Button._25);
        public static final String BUTTON_26 = Gamepad.access$000(Component.Identifier.Button._26);
        public static final String BUTTON_27 = Gamepad.access$000(Component.Identifier.Button._27);
        public static final String BUTTON_28 = Gamepad.access$000(Component.Identifier.Button._28);
        public static final String BUTTON_29 = Gamepad.access$000(Component.Identifier.Button._29);
        public static final String BUTTON_3 = Gamepad.access$000(Component.Identifier.Button._3);
        public static final String BUTTON_30 = Gamepad.access$000(Component.Identifier.Button._30);
        public static final String BUTTON_31 = Gamepad.access$000(Component.Identifier.Button._31);
        public static final String BUTTON_4 = Gamepad.access$000(Component.Identifier.Button._4);
        public static final String BUTTON_5 = Gamepad.access$000(Component.Identifier.Button._5);
        public static final String BUTTON_6 = Gamepad.access$000(Component.Identifier.Button._6);
        public static final String BUTTON_7 = Gamepad.access$000(Component.Identifier.Button._7);
        public static final String BUTTON_8 = Gamepad.access$000(Component.Identifier.Button._8);
        public static final String BUTTON_9 = Gamepad.access$000(Component.Identifier.Button._9);
        public static final String A = Gamepad.access$000(Component.Identifier.Button.A);
        public static final String B = Gamepad.access$000(Component.Identifier.Button.B);
        public static final String BASE = Gamepad.access$000(Component.Identifier.Button.BASE);
        public static final String BASE2 = Gamepad.access$000(Component.Identifier.Button.BASE2);
        public static final String BASE3 = Gamepad.access$000(Component.Identifier.Button.BASE3);
        public static final String BASE4 = Gamepad.access$000(Component.Identifier.Button.BASE4);
        public static final String BASE5 = Gamepad.access$000(Component.Identifier.Button.BASE5);
        public static final String BASE6 = Gamepad.access$000(Component.Identifier.Button.BASE6);
        public static final String C = Gamepad.access$000(Component.Identifier.Button.C);
        public static final String LEFT_THUMB = Gamepad.access$000(Component.Identifier.Button.LEFT_THUMB);
        public static final String LEFT_THUMB2 = Gamepad.access$000(Component.Identifier.Button.LEFT_THUMB2);
        public static final String LEFT_THUMB3 = Gamepad.access$000(Component.Identifier.Button.LEFT_THUMB3);
        public static final String MODE = Gamepad.access$000(Component.Identifier.Button.MODE);
        public static final String PINKIE = Gamepad.access$000(Component.Identifier.Button.PINKIE);
        public static final String RIGHT_THUMB = Gamepad.access$000(Component.Identifier.Button.RIGHT_THUMB);
        public static final String RIGHT_THUMB2 = Gamepad.access$000(Component.Identifier.Button.RIGHT_THUMB2);
        public static final String RIGHT_THUMB3 = Gamepad.access$000(Component.Identifier.Button.RIGHT_THUMB3);
        public static final String SELECT = Gamepad.access$000(Component.Identifier.Button.SELECT);
        public static final String START = Gamepad.access$000(Component.Identifier.Button.START);
        public static final String THUMB = Gamepad.access$000(Component.Identifier.Button.THUMB);
        public static final String THUMB2 = Gamepad.access$000(Component.Identifier.Button.THUMB2);
        public static final String TOP = Gamepad.access$000(Component.Identifier.Button.TOP);
        public static final String TOP2 = Gamepad.access$000(Component.Identifier.Button.TOP2);
        public static final String TRIGGER = Gamepad.access$000(Component.Identifier.Button.TRIGGER);
        public static final String X = Gamepad.access$000(Component.Identifier.Button.X);
        public static final String Y = Gamepad.access$000(Component.Identifier.Button.Y);
        public static final String Z = Gamepad.access$000(Component.Identifier.Button.Z);

        private Buttons() {
        }
    }

    public static class Axis {
        public static final String POV = Gamepad.access$000(Component.Identifier.Axis.POV);
        public static final String RX = Gamepad.access$000(Component.Identifier.Axis.RX);
        public static final String RX_ACCELERATION = Gamepad.access$000(Component.Identifier.Axis.RX_ACCELERATION);
        public static final String RX_FORCE = Gamepad.access$000(Component.Identifier.Axis.RX_FORCE);
        public static final String RX_VELOCITY = Gamepad.access$000(Component.Identifier.Axis.RX_VELOCITY);
        public static final String RY = Gamepad.access$000(Component.Identifier.Axis.RY);
        public static final String RY_ACCELERATION = Gamepad.access$000(Component.Identifier.Axis.RY_ACCELERATION);
        public static final String RY_FORCE = Gamepad.access$000(Component.Identifier.Axis.RY_FORCE);
        public static final String RY_VELOCITY = Gamepad.access$000(Component.Identifier.Axis.RY_VELOCITY);
        public static final String RZ = Gamepad.access$000(Component.Identifier.Axis.RZ);
        public static final String RZ_ACCELERATION = Gamepad.access$000(Component.Identifier.Axis.RZ_ACCELERATION);
        public static final String RZ_FORCE = Gamepad.access$000(Component.Identifier.Axis.RZ_FORCE);
        public static final String RZ_VELOCITY = Gamepad.access$000(Component.Identifier.Axis.RZ_VELOCITY);
        public static final String SLIDER = Gamepad.access$000(Component.Identifier.Axis.SLIDER);
        public static final String SLIDER_ACCELERATION = Gamepad.access$000(Component.Identifier.Axis.SLIDER_ACCELERATION);
        public static final String SLIDER_FORCE = Gamepad.access$000(Component.Identifier.Axis.SLIDER_FORCE);
        public static final String SLIDER_VELOCITY = Gamepad.access$000(Component.Identifier.Axis.SLIDER_VELOCITY);
        public static final String X = Gamepad.access$000(Component.Identifier.Axis.X);
        public static final String X_ACCELERATION = Gamepad.access$000(Component.Identifier.Axis.X_ACCELERATION);
        public static final String X_FORCE = Gamepad.access$000(Component.Identifier.Axis.X_FORCE);
        public static final String X_VELOCITY = Gamepad.access$000(Component.Identifier.Axis.X_VELOCITY);
        public static final String Y = Gamepad.access$000(Component.Identifier.Axis.Y);
        public static final String Y_ACCELERATION = Gamepad.access$000(Component.Identifier.Axis.Y_ACCELERATION);
        public static final String Y_FORCE = Gamepad.access$000(Component.Identifier.Axis.Y_FORCE);
        public static final String Y_VELOCITY = Gamepad.access$000(Component.Identifier.Axis.Y_VELOCITY);
        public static final String Z = Gamepad.access$000(Component.Identifier.Axis.Z);
        public static final String Z_ACCELERATION = Gamepad.access$000(Component.Identifier.Axis.Z_ACCELERATION);
        public static final String Z_FORCE = Gamepad.access$000(Component.Identifier.Axis.Z_FORCE);
        public static final String Z_VELOCITY = Gamepad.access$000(Component.Identifier.Axis.Z_VELOCITY);

        private Axis() {
        }
    }
}

