/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui.screens;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.graphics.RenderComponent;
import de.gurkenlabs.litiengine.gui.screens.IScreenManager;
import de.gurkenlabs.litiengine.gui.screens.Resolution;
import de.gurkenlabs.litiengine.gui.screens.Screen;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.swing.JFrame;

public class ScreenManager
extends JFrame
implements IScreenManager {
    private static final int SCREENCHANGETIMEOUT = 200;
    private static final int ICONIFIED_MAX_FPS = 1;
    private static final int NONE_FOCUS_MAX_FPS = 10;
    private static final long serialVersionUID = 7958549828482285935L;
    private final transient List<Consumer<Dimension>> resolutionChangedConsumer = new CopyOnWriteArrayList<Consumer<Dimension>>();
    private final transient List<Consumer<Screen>> screenChangedConsumer = new CopyOnWriteArrayList<Consumer<Screen>>();
    private final transient List<Screen> screens = new CopyOnWriteArrayList<Screen>();
    private transient Screen currentScreen;
    private long lastScreenChange = 0L;
    private final RenderComponent renderCanvas = new RenderComponent(Game.getConfiguration().graphics().getResolution());
    private float resolutionScale = 1.0f;
    private Dimension resolution;
    private Point screenLocation;

    public ScreenManager(String gameTitle) {
        super(gameTitle);
        if (!Game.isInNoGUIMode()) {
            this.setResizable(false);
            this.setBackground(Color.BLACK);
            this.setDefaultCloseOperation(3);
            this.setDefaultCloseOperation(0);
            this.add(this.renderCanvas);
            this.initializeEventListeners();
        }
    }

    @Override
    public void addScreen(Screen screen) {
        screen.setWidth(this.getWidth());
        screen.setHeight(this.getHeight());
        this.screens.add(screen);
        if (this.getCurrentScreen() == null) {
            this.displayScreen(screen);
        }
    }

    @Override
    public void displayScreen(Screen screen) {
        if (Game.hasStarted() && System.currentTimeMillis() - this.lastScreenChange < 200L) {
            return;
        }
        if (this.getCurrentScreen() != null) {
            this.getCurrentScreen().suspend();
        }
        if (!this.screens.contains(screen)) {
            this.screens.add(screen);
        }
        this.currentScreen = screen;
        if (!Game.isInNoGUIMode()) {
            this.getCurrentScreen().prepare();
            this.setVisible(true);
        }
        this.lastScreenChange = System.currentTimeMillis();
        for (Consumer<Screen> consumer : this.screenChangedConsumer) {
            consumer.accept(this.getCurrentScreen());
        }
    }

    @Override
    public void displayScreen(String screen) {
        if (this.getCurrentScreen() != null && this.getCurrentScreen().getName().equalsIgnoreCase(screen) || this.screens.stream().noneMatch(element -> element.getName().equalsIgnoreCase(screen))) {
            return;
        }
        Optional<Screen> opt = this.screens.stream().filter(element -> element.getName().equalsIgnoreCase(screen)).findFirst();
        if (!opt.isPresent()) {
            return;
        }
        this.displayScreen(opt.get());
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.getResolution().width / 2.0, (double)this.getResolution().height / 2.0);
    }

    @Override
    public Screen getCurrentScreen() {
        return this.currentScreen;
    }

    @Override
    public RenderComponent getRenderComponent() {
        return this.renderCanvas;
    }

    @Override
    public Dimension getResolution() {
        return this.resolution;
    }

    @Override
    public Point getScreenLocation() {
        if (this.screenLocation != null) {
            return this.screenLocation;
        }
        this.screenLocation = this.getLocationOnScreen();
        return this.screenLocation;
    }

    @Override
    public void init(int width, int height, boolean fullscreen) {
        if (Game.isInNoGUIMode()) {
            this.resolution = new Dimension(0, 0);
            this.setVisible(false);
            return;
        }
        if (fullscreen) {
            this.setUndecorated(true);
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            if (gd.isFullScreenSupported()) {
                gd.setFullScreenWindow(this);
            } else {
                System.err.println("Full screen is not supported on this device.");
                this.setExtendedState(6);
                this.setVisible(true);
            }
            this.setResolution(Resolution.custom(this.getSize().width, this.getSize().height, "fullscreen"));
        } else {
            this.setResolution(Game.getConfiguration().graphics().getResolution());
            this.setVisible(true);
        }
        this.getRenderComponent().init();
        this.resolution = this.getRenderComponent().getSize();
        this.requestFocus();
    }

    @Override
    public boolean isFocusOwner() {
        if (this.getRenderComponent() instanceof Component && this.getRenderComponent().isFocusOwner()) {
            return true;
        }
        return super.isFocusOwner();
    }

    @Override
    public void onResolutionChanged(Consumer<Dimension> resolutionConsumer) {
        if (this.resolutionChangedConsumer.contains(resolutionConsumer)) {
            return;
        }
        this.resolutionChangedConsumer.add(resolutionConsumer);
    }

    @Override
    public void onScreenChanged(Consumer<Screen> screenConsumer) {
        if (!this.screenChangedConsumer.contains(screenConsumer)) {
            this.screenChangedConsumer.add(screenConsumer);
        }
    }

    @Override
    public void setResolution(Resolution res) {
        this.setResolution(res.getDimension());
    }

    @Override
    public float getResolutionScale() {
        return this.resolutionScale;
    }

    private void setResolution(Dimension dim) {
        Dimension insetAwareDimension = new Dimension(dim.width + this.getInsets().left + this.getInsets().right, dim.height + this.getInsets().top + this.getInsets().bottom);
        if (Game.getConfiguration().graphics().enableResolutionScaling()) {
            this.resolutionScale = (float)(dim.getWidth() / (double)Resolution.Ratio16x9.RES_1920x1080.getWidth());
            Game.getRenderEngine().setBaseRenderScale(Game.getRenderEngine().getBaseRenderScale() * this.resolutionScale);
        }
        this.setSize(insetAwareDimension);
    }

    private void initializeEventListeners() {
        this.getRenderComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ScreenManager.this.resolution = ScreenManager.this.getRenderComponent().getSize();
                ScreenManager.this.resolutionChangedConsumer.forEach(consumer -> consumer.accept(ScreenManager.this.getSize()));
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                ScreenManager.this.screenLocation = null;
            }
        });
        this.addWindowStateListener(e -> {
            if (e.getNewState() == 1) {
                Game.getRenderLoop().setMaxFps(1);
            } else {
                Game.getRenderLoop().setMaxFps(Game.getConfiguration().client().getMaxFps());
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (Game.getConfiguration().graphics().reduceFramesWhenNotFocused()) {
                    Game.getRenderLoop().setMaxFps(10);
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                Game.getRenderLoop().setMaxFps(Game.getConfiguration().client().getMaxFps());
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        });
    }
}

